/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.BaseResponse;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.entity.SysOplog;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.SysOplogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u5fd7\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/syslog"})
public class SysLogController {
    @Autowired
    SysOplogService sysOplogService;
    @Autowired
    private IOauth2Service auth2Service;

    @ApiOperation(value="\u5217\u51fa\u6240\u6709\u6743\u9650\u7ec4")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase list(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage oplogs = this.sysOplogService.findPageByFilterParam(filterParam, page.intValue(), size.intValue());
            responseDataBase.put((Object)"data", (Object)oplogs);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6dfb\u52a0\u65e5\u5fd7")
    @RequestMapping(value={"/addOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addOne(HttpServletRequest request, @ModelAttribute SysOplog oplog) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            String userId = this.auth2Service.queryCurrentUserId(request);
            oplog.setUserid(userId);
            this.sysOplogService.save((Object)oplog);
        }
        catch (Exception e) {
            baseResponse.markFailure();
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355\u6253\u5f00\u65e5\u5fd7")
    @RequestMapping(value={"/addMenuOplog"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addMenuOplog(HttpServletRequest request, @RequestParam(value="systemKey", required=true) String systemKey, @RequestParam(value="menuId", required=true) String menuId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            this.sysOplogService.addMenuOpLog(request, systemKey, menuId);
        }
        catch (Exception e) {
            baseResponse.markFailure();
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }
}

