/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.service.dev.IOrganizationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7ed3\u6784\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/organization"})
public class SysOrganizationController {
    @Autowired
    private IOrganizationService sysOrganizationService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u673a\u6784\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysOrganization org) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.saveOrUp(org);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u90e8\u95e8")
    @RequestMapping(value={"/batchSave"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchSave(@RequestParam(value="jsonOrgs", required=true) String jsonOrgs) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgs = JSONArray.parseArray((String)jsonOrgs, SysOrganization.class);
            this.sysOrganizationService.batchSave(orgs);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgTree = this.sysOrganizationService.queryTree(filterParam);
            responseDataBase.put((Object)"data", (Object)orgTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6309\u673a\u6784ID\u67e5\u8be2\u5176\u4e0b\u7ea7\u673a\u6784\u6811")
    @RequestMapping(value={"/queryTreeById"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTreeById(String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgTree = this.sysOrganizationService.queryListById(id);
            responseDataBase.put((Object)"data", (Object)orgTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgs = this.sysOrganizationService.queryList(filterParam);
            responseDataBase.put((Object)"data", (Object)orgs);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage pages = this.sysOrganizationService.queryPage(filterParam, page.intValue(), size.intValue());
            responseDataBase.put((Object)"data", (Object)pages);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u90e8\u95e8\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id, @RequestParam(value="filterParam", required=false) String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysOrganization org = this.sysOrganizationService.findOneById(id, filterParam);
            responseDataBase.put((Object)"data", (Object)org);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u673a\u6784\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.batchDelete(id);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @OpLog(name="\u5220\u9664\u673a\u6784\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpLog.OpType.add)
    @RequestMapping(value={"/addUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase addUser(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userId", required=true) String userId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.bindOneUser(orgId, userId);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/bindUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase bindUsers(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userIds", required=true) String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.bindUsers(orgId, userIds);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u79fb\u9664\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @OpLog(name="\u79fb\u9664\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/removeUsers"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase removeUsers(@RequestParam(value="orgId", required=true) String orgId, @RequestParam(value="userIds", required=true) String userIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysOrganizationService.removeBindUser(orgId, userIds);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelUsers(@RequestParam(value="orgId", required=true) String orgId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.sysOrganizationService.queryRelUsers(orgId);
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u65e0\u7ec4\u7ec7\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/nonOrgUsers"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase nonOrgUsers() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.sysOrganizationService.queryNonOrgUsers();
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u91cf")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryCount(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            int count = this.sysOrganizationService.queryCount(filterParam);
            responseDataBase.put((Object)"data", (Object)count);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

