/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysPermissionGroup;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysPermissionApplicationService;
import com.geoway.design.biz.service.sys.ISysPermissionGroupService;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysPermissionSubfunctionService;
import com.geoway.design.biz.service.sys.ISysPermissionSystemService;
import com.geoway.design.biz.service.sys.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6743\u9650\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/permisson"})
public class SysPermissonController {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysPermissionGroupService sysPermissionGroupService;
    @Autowired
    private ISysPermissionSystemService sysPermissionSystemService;
    @Autowired
    private ISysPermissionApplicationService sysPermissionApplicationService;
    @Autowired
    private ISysPermissionSubfunctionService sysPermissionSubfunctionService;
    @Autowired
    private IOauth2Service auth2Service;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6743\u9650\u7ec4")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u6743\u9650\u7ec4", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveGroup"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase save(SysPermissionGroup group) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysPermissionGroupService.saveOrUpdate((Object)group);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6743\u9650")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u6743\u9650", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase save(SysPermission permission) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysPermission oldPerm;
            if (StrUtil.isNotBlank((CharSequence)permission.getId()) && (oldPerm = (SysPermission)this.sysPermissionService.getById((Serializable)((Object)permission.getId()))) != null) {
                permission.setCreatetime(oldPerm.getCreatetime());
            }
            this.sysPermissionService.saveOrUp(permission);
            responseDataBase.put((Object)"data", (Object)permission.getId());
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5217\u51fa\u6240\u6709\u6743\u9650\u7ec4")
    @RequestMapping(value={"/listGroup"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase listGroup(@RequestParam(name="filterParam", required=false) String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List groups = this.sysPermissionGroupService.listByFilter(filterParam, false);
            responseDataBase.put((Object)"data", (Object)groups);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6743\u9650\u6811")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(@RequestParam(name="filterParam", required=false) String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List groups = this.sysPermissionGroupService.listByFilter(filterParam, true);
            responseDataBase.put((Object)"data", (Object)groups);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6743\u9650")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="page", required=true) Integer page, @RequestParam(name="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage permissions = this.sysPermissionService.queryByFilter(filterParam, page, size);
            responseDataBase.put((Object)"data", (Object)permissions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650\u7ec4")
    @OpLog(name="\u5220\u9664\u6743\u9650\u7ec4", opType=OpLog.OpType.del)
    @RequestMapping(value={"/deleteGroup"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteGroup(@RequestParam(name="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysPermissionGroupService.removeById((Serializable)((Object)id));
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6743\u9650\u7ec4")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u6743\u9650\u7ec4", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDeleteGroup"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDeleteGroup(@RequestParam(name="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysPermissionGroupService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650")
    @OpLog(name="\u5220\u9664\u6743\u9650", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysPermissionService.delete(id);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6743\u9650")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u6743\u9650", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysPermissionService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u6743\u9650\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysPermission permission = (SysPermission)this.sysPermissionService.getById((Serializable)((Object)id));
            responseDataBase.put((Object)"data", (Object)permission);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u6743\u9650\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f")
    @RequestMapping(value={"/menus"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonMenus(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemId", required=true) String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List menus = this.sysPermissionService.queryRelateMenus(id, systemId);
            responseDataBase.put((Object)"data", (Object)menus);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u83dc\u5355\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRelateMenu"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateMenu(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemId", required=true) String systemId, @RequestParam(value="menuIds", required=true) String menuIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> menuIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)menuIds)) {
                menuIdList = Arrays.asList(menuIds.split(","));
            }
            this.sysPermissionService.saveRelateMenus(id, systemId, menuIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u529f\u80fd\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u529f\u80fd\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRelateFunction"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateFunction(@RequestParam(value="id", required=true) String id, @RequestParam(value="applicationId", required=true) String applicationId, @RequestParam(value="functionIds", required=true) String functionIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> functionIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)functionIds)) {
                functionIdList = Arrays.asList(functionIds.split(","));
            }
            this.sysPermissionService.saveRelateFunctions(id, applicationId, functionIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u6743\u9650\u5173\u8054\u7684\u529f\u80fd\u4fe1\u606f")
    @RequestMapping(value={"/functions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonFunctions(@RequestParam(value="id", required=true) String id, @RequestParam(value="applicationId", required=true) String applicationId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List functions = this.sysPermissionService.queryRelateFunctions(id, applicationId);
            responseDataBase.put((Object)"data", (Object)functions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u6743\u9650\u4fe1\u606f")
    @RequestMapping(value={"/queryRolePermisson"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRolePermisson(@RequestParam(value="roleIds", required=true) String roleIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List permissions = this.sysPermissionService.queryRolePermissons(roleIds);
            responseDataBase.put((Object)"data", (Object)permissions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRelateSystem"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateSystem(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemIds", required=true) String systemIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> systemIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)systemIds)) {
                systemIdList = Arrays.asList(systemIds.split(","));
            }
            this.sysPermissionSystemService.batchSave(id, systemIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u5220\u9664\u6743\u9650\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/delRelateSystem"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delRelateSystem(@RequestParam(value="id", required=true) String id, @RequestParam(value="systemIds", required=true) String systemIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> systemIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)systemIds)) {
                systemIdList = Arrays.asList(systemIds.split(","));
            }
            this.sysPermissionSystemService.batchDelete(id, systemIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u6743\u9650\u5173\u8054\u7684\u7cfb\u7edf\u4fe1\u606f")
    @RequestMapping(value={"/systems"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonSystems(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List systems = this.sysPermissionSystemService.queryByPermissionId(id);
            responseDataBase.put((Object)"data", (Object)systems);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u6743\u9650\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f")
    @RequestMapping(value={"/applications"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonApplications(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List applications = this.sysPermissionApplicationService.queryByPermissionId(id);
            responseDataBase.put((Object)"data", (Object)applications);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u6743\u9650\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRelateApplication"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateApplication(@RequestParam(value="id", required=true) String id, @RequestParam(value="applicationIds", required=true) String applicationIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> applicationIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)applicationIds)) {
                applicationIdList = Arrays.asList(applicationIds.split(","));
            }
            this.sysPermissionApplicationService.batchSave(id, applicationIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f")
    @OpLog(name="\u5220\u9664\u6743\u9650\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/delRelateApplication"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delRelateApplication(@RequestParam(value="id", required=true) String id, @RequestParam(value="appIds", required=true) String appIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> appIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)appIds)) {
                appIdList = Arrays.asList(appIds.split(","));
            }
            this.sysPermissionApplicationService.batchDelete(id, appIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u5173\u8054\u7684\u5b50\u529f\u80fd\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u83dc\u5355\u5173\u8054\u7684\u5b50\u529f\u80fd\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRelateSubFunction"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateSubFunction(@RequestParam(value="id", required=true) String id, @RequestParam(value="menuId", required=true) String menuId, @RequestParam(value="funIds", required=true) String funIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List<Object> funIdList = new ArrayList();
            if (StrUtil.isNotBlank((CharSequence)funIds)) {
                funIdList = Arrays.asList(funIds.split(","));
            }
            this.sysPermissionSubfunctionService.batchSave(id, menuId, funIdList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u83dc\u5355\u5173\u8054\u7684\u5b50\u529f\u80fd\u4fe1\u606f")
    @RequestMapping(value={"/subFunctions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonSubFunctions(@RequestParam(value="id", required=true) String id, @RequestParam(value="menuId", required=true) String menuId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List groups = this.sysPermissionSubfunctionService.queryByPermissionId(id, menuId);
            responseDataBase.put((Object)"data", (Object)groups);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u83dc\u5355\u5173\u8054\u7684\u5b50\u529f\u80fd\u4fe1\u606f")
    @RequestMapping(value={"/userMenuFunctions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryUserMenuFunctions(HttpServletRequest request, @RequestParam(value="menuId", required=true) String menuId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List functions = new ArrayList();
            String userId = this.auth2Service.queryCurrentUserId(request);
            List roles = this.sysUserService.queryRelRoles(userId);
            if (roles.size() > 0) {
                List roleIds = roles.stream().map(i -> i.getId()).collect(Collectors.toList());
                List permissions = this.sysPermissionService.queryRolePermissons(roleIds);
                List permissionIds = permissions.stream().map(i -> i.getId()).collect(Collectors.toList());
                functions = this.sysPermissionSubfunctionService.querySubFunctionByPermissionIdList(permissionIds, menuId);
            }
            responseDataBase.put((Object)"data", functions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u529f\u80fd\u6743\u9650")
    @RequestMapping(value={"/userAppFunctions"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase userAppFunctions(HttpServletRequest request, String appId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            ArrayList<JSONObject> appFunctions = new ArrayList<JSONObject>();
            String userId = this.auth2Service.queryCurrentUserId(request);
            List roles = this.sysUserService.queryRelRoles(userId);
            if (roles.size() > 0) {
                List roleIds = roles.stream().map(SysRole::getId).collect(Collectors.toList());
                List permissions = this.sysPermissionService.queryRolePermissons(roleIds);
                for (SysPermission permission : permissions) {
                    List applications = this.sysPermissionApplicationService.queryByPermissionId(permission.getId());
                    if (StrUtil.isNotBlank((CharSequence)appId)) {
                        applications = applications.stream().filter(f -> f.getId().equals(appId)).collect(Collectors.toList());
                    }
                    if (applications.size() == 0) continue;
                    List applicationArr = applications.stream().map(application -> {
                        List functions = this.sysPermissionService.queryRelateFunctions(permission.getId(), application.getId());
                        JSONObject applicationJO = JSON.parseObject((String)JSON.toJSONString((Object)application));
                        applicationJO.put("functions", (Object)functions);
                        return applicationJO;
                    }).collect(Collectors.toList());
                    JSONObject permissionJO = JSON.parseObject((String)JSON.toJSONString((Object)permission));
                    permissionJO.put("applications", applicationArr);
                    appFunctions.add(permissionJO);
                }
            }
            responseDataBase.put((Object)"data", appFunctions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

