/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysXzqRegionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8f96\u533a\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/region"})
public class SysRegionController {
    @Autowired
    private ISysRegionService sysRegionService;
    @Autowired
    private ISysXzqRegionService sysXzqRegionService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u8f96\u533a", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysRegion region) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRegionService.saveOrUp(region);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(String filterParam, String sortParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            if (StrUtil.isBlank((CharSequence)sortParam)) {
                sortParam = "SORT_code_ASC";
            }
            List regionTree = this.sysRegionService.queryTree(filterParam, sortParam);
            responseDataBase.put((Object)"data", (Object)regionTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u884c\u653f\u533a\u7ed3\u6784")
    @RequestMapping(value={"/queryXzqTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryXzqTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List regionTree = this.sysXzqRegionService.queryRegionTree(filterParam);
            responseDataBase.put((Object)"data", (Object)regionTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam, String sortParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            if (StrUtil.isBlank((CharSequence)sortParam)) {
                sortParam = "SORT_code_ASC";
            }
            List regionTree = this.sysRegionService.queryList(filterParam, sortParam);
            responseDataBase.put((Object)"data", (Object)regionTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryXzqList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryXzqList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List regions = this.sysXzqRegionService.queryList(filterParam);
            responseDataBase.put((Object)"data", (Object)regions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6ce8\u518c\u884c\u653f\u533a\u5230\u8f96\u533a")
    @OpLog(name="\u6ce8\u518c\u884c\u653f\u533a\u5230\u8f96\u533a", opType=OpLog.OpType.update)
    @RequestMapping(value={"/registerRegionByXzq"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase registerRegionByXzq(String rootCode) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List regions = this.sysRegionService.registerRegionByXzq(rootCode);
            responseDataBase.put((Object)"data", (Object)regions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage pages = this.sysRegionService.queryPage(filterParam, page.intValue(), size.intValue());
            responseDataBase.put((Object)"data", (Object)pages);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u8f96\u533a\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id, @RequestParam(value="filterParam", required=false) String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysRegion region = this.sysRegionService.findOne(id, filterParam);
            responseDataBase.put((Object)"data", (Object)region);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u8f96\u533a", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRegionService.batchDelete(id);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @OpLog(name="\u6279\u91cf\u5220\u9664", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRegionService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="excel\u5bfc\u5165")
    @OpLog(name="excel\u5bfc\u5165", opType=OpLog.OpType.add)
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase excelImport(@RequestParam MultipartFile multipartFile) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRegionService.excelImport(multipartFile.getInputStream());
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="excel\u5bfc\u51fa")
    @OpLog(name="excel\u5bfc\u51fa", opType=OpLog.OpType.add)
    @RequestMapping(value={"/excelOutput"}, method={RequestMethod.POST, RequestMethod.GET})
    public void excelOutput(@RequestParam String rootCode, HttpServletResponse response) {
        try {
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode("\u8f96\u533a\u5bfc\u51fa-" + rootCode, "UTF-8") + ".xls");
            response.setHeader("Content-Transfer-Encoding", "binary");
            this.sysRegionService.excelOutput((OutputStream)response.getOutputStream(), rootCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

