/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.service.sys.ISysPermissionService;
import com.geoway.design.biz.service.sys.ISysRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/role"})
public class SysRoleController {
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysPermissionService sysPermissionService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u89d2\u8272", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysRole role) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.saveOrUp(role);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roleTree = this.sysRoleService.queryTree(filterParam);
            responseDataBase.put((Object)"data", (Object)roleTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roleTree = this.sysRoleService.queryList(filterParam);
            responseDataBase.put((Object)"data", (Object)roleTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage pages = this.sysRoleService.queryPage(filterParam, page.intValue(), size.intValue());
            responseDataBase.put((Object)"data", (Object)pages);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id, @RequestParam(value="filterParam", required=false) String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysRole role = this.sysRoleService.findOne(id, filterParam);
            responseDataBase.put((Object)"data", (Object)role);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u89d2\u8272", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.batchDelete(id);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u5173\u8054\u7684\u6743\u9650\u4fe1\u606f")
    @RequestMapping(value={"/permissions"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPermissonMenus(@RequestParam(value="id", required=true) String roleIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List permissions = this.sysPermissionService.queryRolePermissons(roleIds);
            responseDataBase.put((Object)"data", (Object)permissions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u5173\u8054\u7684\u6743\u9650\u4fe1\u606f")
    @OpLog(name="\u4fee\u6539\u89d2\u8272\u5173\u8054\u7684\u6743\u9650\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveRolePermissions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveRelateMenu(@RequestParam(value="id", required=true) String id, @RequestParam(value="menuIds", required=true) String permissionIds) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.saveRolePermissions(id, permissionIds);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u6743\u9650\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7684\u7528\u6237")
    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelUsers(@RequestParam(value="roleId", required=true) String roleId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.sysRoleService.queryRelUsers(roleId);
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f\u7f6e\u6362")
    @RequestMapping(value={"/sort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase sortUp(@RequestParam(value="id", required=true) String id, @RequestParam(value="pid", required=true) String pid, @RequestParam(value="flag", required=true) Integer flag) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.sortRoles(id, pid, flag.intValue());
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f\u7f6e\u6362")
    @RequestMapping(value={"/drag"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase drag(@RequestParam(value="id", required=true) String id, @RequestParam(value="refId", required=true) String refId, @RequestParam(value="type", required=true) String type) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysRoleService.dragRoleNode(id, refId, type);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4e2a\u6570")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryCount(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            int count = this.sysRoleService.queryCount(filterParam);
            responseDataBase.put((Object)"data", (Object)count);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

