/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.domain.RestResult;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.base.support.ExcelUtil;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.biz.vo.SysUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/user"})
public class SysUserController {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IOauth2Service auth2Service;

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237")
    @RequestMapping(value={"/queryByTel"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryByTel(@RequestParam String tel) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage pages = this.sysUserService.queryPage("telEncrypt_EQ_" + AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"), 1, 1);
            responseDataBase.put((Object)"data", pages.getRecords().size() > 0 ? pages.getRecords().get(0) : null);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @OpLog(name="\u4fee\u6539\u7528\u6237\u5bc6\u7801", opType=OpLog.OpType.update)
    @RequestMapping(value={"/setPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase setPassword(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="password", required=true) String password) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.changeUserPassword(userId, password);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u771f\u5b9e\u624b\u673a\u53f7")
    @RequestMapping(value={"/getRealTel"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getRealTel(String userId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysUser user = this.sysUserService.queryOne(userId);
            String reaTel = user.getTelEncrypt() == null ? null : AESUtils.decrypt((String)user.getTelEncrypt(), (String)"FWAijk4A2Dwt2MKw");
            responseDataBase.put((Object)"data", (Object)reaTel);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @OpLog(name="\u4fee\u6539\u7528\u6237\u5bc6\u7801", opType=OpLog.OpType.update)
    @RequestMapping(value={"/modifyPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase modifyPassword(@RequestParam String phoneNum, @RequestParam String verifyCode, @RequestParam String verifyCodeUid, @RequestParam String password) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.modifyPassword(phoneNum, verifyCode, verifyCodeUid, password);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7528\u6237", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysUser user, @RequestParam(value="deletePhoto", required=false) Integer deletePhoto, @RequestParam(value="file", required=false) MultipartFile file) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            boolean isDeletePhoto = deletePhoto == 1;
            this.sysUserService.saveOrUp(user, file, isDeletePhoto);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u7528\u6237")
    @OpLog(name="\u6279\u91cf\u4fee\u6539\u7528\u6237", opType=OpLog.OpType.update)
    @RequestMapping(value={"/batchSave"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchSave(String usersJson) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = JSONArray.parseArray((String)usersJson, SysUser.class);
            this.sysUserService.batchSave(users);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.sysUserService.queryList(filterParam);
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(@RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage pages = this.sysUserService.queryPage(filterParam, page.intValue(), size.intValue());
            responseDataBase.put((Object)"data", (Object)pages);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase findOne(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            SysUser user = this.sysUserService.queryOne(id);
            responseDataBase.put((Object)"data", (Object)user);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u4e00\u6761\u7528\u6237\u8bb0\u5f55")
    @OpLog(name="\u5220\u9664\u7528\u6237", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase delete(String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.deleteOne(id);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7528\u6237")
    @OpLog(name="\u6279\u91cf\u5220\u9664\u7528\u6237", opType=OpLog.OpType.del)
    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase batchDelete(@RequestParam(value="ids", required=true) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.batchDelete(ids);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u7684\u89d2\u8272")
    @RequestMapping(value={"/roles"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelRoles(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roles = this.sysUserService.queryRelRoles(id);
            responseDataBase.put((Object)"data", (Object)roles);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/orgs"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelOrgs(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgs = this.sysUserService.queryRelOrgs(id);
            responseDataBase.put((Object)"data", (Object)orgs);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u5173\u8054\u8f96\u533a")
    @RequestMapping(value={"/regions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRelRegions(@RequestParam(value="id", required=true) String id) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List regions = this.sysUserService.queryRelRegions(id);
            responseDataBase.put((Object)"data", (Object)regions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237token\uff0c\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/getUserInfoByToken"})
    public RestResult<SysUserVO> getUserInfoByToken(HttpServletRequest request) {
        String userId = this.auth2Service.queryCurrentUserId(request);
        if (StrUtil.isBlank((CharSequence)userId)) {
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return RestResult.success((Object)this.sysUserService.getUserInfoByUserId(userId));
    }

    @ApiOperation(value="Excel \u7528\u6237\u6279\u91cf\u5bfc\u5165", notes="\u9700\u8981\u4e0a\u4f20\u7528\u6237\u4fe1\u606f\u6a21\u677f\u7684Excel\u6570\u636e")
    @OpLog(name="\u7528\u6237\u6279\u91cf\u5bfc\u5165", opType=OpLog.OpType.update)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="Excel\u6587\u4ef6", dataType="File"), @ApiImplicitParam(name="updateSupport", value="\u662f\u5426\u8986\u76d6\u66f4\u65b0", dataType="Boolean", defaultValue="false")})
    @PostMapping(value={"/import"})
    public ResponseDataBase importExcel(MultipartFile file, boolean updateSupport) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List excelUserList = ExcelUtil.importExcel((MultipartFile)file, (Integer)0, (Integer)1, SysUser.class);
            String message = this.sysUserService.importUsers(excelUserList, Boolean.valueOf(updateSupport));
            responseDataBase.put((Object)"data", (Object)message);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="Excel \u7528\u6237\u6279\u91cf\u5bfc\u51fa")
    @OpLog(name="Excel \u7528\u6237\u6279\u91cf\u5bfc\u51fa", opType=OpLog.OpType.update)
    @GetMapping(value={"/export"})
    public void exportExcel(@RequestParam(value="filterParam", required=false) String filterParam, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sysUserService.exportUsers(filterParam, Boolean.valueOf(false), response);
    }

    @ApiOperation(value="Excel \u5bfc\u51fa\u7528\u6237Excel\u6a21\u677f")
    @GetMapping(value={"/exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sysUserService.exportUsers("", Boolean.valueOf(true), response);
    }

    @ApiOperation(value="\u6743\u9650\u4e0e\u6743\u9650\u7ec4\u4fee\u6539")
    @RequestMapping(value={"/upRoles"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase upRoles(SysUser user) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.updateRoles(user);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6236\u6570\u91cf")
    @RequestMapping(value={"/queryCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryCount(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            Map map = this.sysUserService.queryCount(filterParam);
            responseDataBase.put((Object)"data", (Object)map);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @RequestMapping(value={"/changePwd"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase changePwd(HttpServletRequest request, @RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String userId = this.auth2Service.queryCurrentUserId(request);
            this.sysUserService.changePasswordByUserId(userId, oldPwd, newPwd);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5e93\u8868\u7ef4\u62a4-\u52a0\u5bc6\u624b\u673a\u53f7")
    @RequestMapping(value={"/encryptPhone"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase encryptPhone(HttpServletRequest request, String phone) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.encryptPhone(phone);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5e93\u8868\u7ef4\u62a4-\u89e3\u5bc6\u624b\u673a\u53f7")
    @RequestMapping(value={"/decryptPhone"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase decryptPhone(HttpServletRequest request, String encryptPhone) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.decryptPhone(encryptPhone);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

