/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller.uisapi;

import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.service.uis.IUISService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4effUIS1.0\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/rest"})
public class CommonRestController {
    @Autowired
    private IUISService uisService;

    @ApiOperation(value="\u7528\u6237\u67e5\u8be2")
    @RequestMapping(value={"/user/getUserInfo", "/user/getSimpleUserInfo"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getUserInfo(@RequestParam Map<String, String> map, HttpServletRequest request) throws Exception {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List arrayList = this.uisService.getUserInfo(map);
        responseDataBase.put((Object)"data", (Object)arrayList);
        return responseDataBase;
    }

    @ApiOperation(value="\u7528\u6237\u4fee\u6539")
    @RequestMapping(value={"/user/modify"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase modify(@RequestParam Map<String, String> map) {
        this.uisService.modifyUserInfo(map);
        return ResponseDataBase.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/user/getUserList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getUserList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List simpleUserList = this.uisService.getUserList(filterParam);
            responseDataBase.put((Object)"data", (Object)simpleUserList);
        }
        catch (Exception ex) {
            return ResponseDataBase.error((String)ex.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @RequestMapping(value={"/org/getOrgTree"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getOrgTree(@RequestParam Map<String, String> paramMap) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List organizationList = this.uisService.getOrgTree(paramMap);
        responseDataBase.put((Object)"data", (Object)organizationList);
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u4fe1\u606f")
    @RequestMapping(value={"/org/getOrgInfo"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase getOrgInfo(@RequestParam Map<String, String> paramMap) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List orgList = this.uisService.getOrgInfo(paramMap);
            responseDataBase.put((Object)"data", (Object)orgList);
        }
        catch (Exception e) {
            ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6811\u5217\u8868")
    @RequestMapping(value={"/role/queryTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roleTree = this.uisService.queryRoleTree(filterParam);
            responseDataBase.put((Object)"data", (Object)roleTree);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6743\u9650")
    @RequestMapping(value={"/role/permissions"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRolePermissions(@RequestBody Map<String, String> paramMap) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List permissions = this.uisService.queryRolePermissions(paramMap);
            responseDataBase.put((Object)"data", (Object)permissions);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @RequestMapping(value={"/role/list"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List roles = this.uisService.queryRoleList(filterParam);
            responseDataBase.put((Object)"data", (Object)roles);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237")
    @RequestMapping(value={"/role/users"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryRoleUsers(String roleId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List users = this.uisService.queryRoleUsers(roleId);
            responseDataBase.put((Object)"data", (Object)users);
        }
        catch (Exception e) {
            responseDataBase = ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

