/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller.uisapi;

import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.session.redis.RedisSessionMappingStorage;
import com.geoway.sso.client.util.Oauth2Utils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.junit.platform.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4effUIS1.0\u5bf9\u5916\u767b\u5f55\u6388\u6743\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/manager/Oauth"})
public class OathManagerController {
    @Value(value="${sso.server.url}")
    private String serverUrl;
    @Value(value="${sso.app.id}")
    private String appId;
    @Value(value="${sso.app.secret}")
    private String appSecret;
    @Autowired
    private RedisSessionMappingStorage sessionMappingStorage;
    @Autowired
    private PasswordUtil passwordUtil;

    @ApiOperation(value="\u767b\u5f55\u7cfb\u7edf\u83b7\u53d6\u6388\u6743")
    @OpLog(name="\u767b\u5f55\u7cfb\u7edf\u83b7\u53d6\u6388\u6743", opType=OpLog.OpType.login)
    @RequestMapping(value={"/accesstoken", "/accesstokenFromPlatform"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase accesstokenFromPlatform(@RequestParam String appkey, @RequestParam String grant_type, @RequestParam String username, @RequestParam String password, @RequestParam(value="tel", required=false, defaultValue="") String tel, @RequestParam(value="password_type", required=true, defaultValue="md5") String password_type) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        password = this.passwordUtil.getTargetPassword(password, password_type);
        String accessToken = this.sessionMappingStorage.getTokenByUserName(username);
        Result userResult = null;
        if (StringUtils.isNotBlank((String)accessToken)) {
            userResult = Oauth2Utils.queryAccessToken((String)this.serverUrl, (String)accessToken);
        }
        if (userResult == null || userResult.getCode() == 9999) {
            userResult = Oauth2Utils.getAccessToken((String)this.serverUrl, (String)this.appId, (String)this.appSecret, (String)username, (String)password, (String)tel);
        }
        if (!userResult.isSuccess()) {
            return ResponseDataBase.error((String)userResult.getMessage());
        }
        responseDataBase.put((Object)"data", this.generateResult((RpcAccessToken)userResult.getData()));
        return responseDataBase;
    }

    @ApiOperation(value="\u5355\u70b9\u767b\u51fa")
    @OpLog(name="\u5355\u70b9\u767b\u5f55\u9000\u51fa", opType=OpLog.OpType.loginout)
    @RequestMapping(value={"/sessionLogout"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase sessionLogout(@RequestParam Map<String, String> map, HttpServletRequest request) {
        String token = map.get("token");
        Result result = Oauth2Utils.revokeAccessToken((String)this.serverUrl, (String)token);
        if (result.isSuccess()) {
            return ResponseDataBase.error((String)result.getMessage());
        }
        return ResponseDataBase.ok();
    }

    private Map<String, Object> generateResult(RpcAccessToken rpcAccessToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (rpcAccessToken != null) {
            params.put("userid", rpcAccessToken.getUser().getId());
            params.put("username", rpcAccessToken.getUser().getLoginName());
            params.put("rname", rpcAccessToken.getUser().getUserName());
            params.put("access_token", rpcAccessToken.getAccessToken());
            params.put("expires_in", rpcAccessToken.getExpiresIn());
        }
        return params;
    }
}

