-- ----------------------------
--2024年7月4日,新增用户注册表
-- ----------------------------
-- public.sys_user_register definition

-- Drop table

-- DROP TABLE public.sys_user_register;

CREATE TABLE public.sys_user_register (
                                          f_id varchar(32) NOT NULL, -- id
                                          f_name varchar(64) NOT NULL, -- 用户姓名
                                          f_accout varchar(64) NOT NULL, -- 账户名
                                          f_tel varchar(64) NOT NULL, -- 手机号
                                          f_tel_encrypt varchar(255) NOT NULL, -- 加密的手机号
                                          f_audit_state varchar(1) NOT NULL DEFAULT 0, -- 审核状态：0未审核，1通过，2不通过
                                          f_audit_opinion varchar(255) NULL, -- 审核意见
                                          f_audit_user varchar(64) NULL, -- 审核人
                                          f_audit_time timestamptz NULL, -- 审核时间
                                          f_createtime timestamptz NOT NULL, -- 注册时间
                                          f_email varchar(128) NULL, -- 邮箱
                                          f_password varchar(512) NOT NULL, -- 密码
                                          f_organization varchar(64) NOT NULL, -- 组织id
                                          f_region varchar(64) NULL -- 辖区
);

-- Column comments

COMMENT ON COLUMN public.sys_user_register.f_id IS 'id';
COMMENT ON COLUMN public.sys_user_register.f_name IS '用户姓名';
COMMENT ON COLUMN public.sys_user_register.f_accout IS '账户名';
COMMENT ON COLUMN public.sys_user_register.f_tel IS '手机号';
COMMENT ON COLUMN public.sys_user_register.f_tel_encrypt IS '加密的手机号';
COMMENT ON COLUMN public.sys_user_register.f_audit_state IS '审核状态：0未审核，1通过，2不通过';
COMMENT ON COLUMN public.sys_user_register.f_audit_opinion IS '审核意见';
COMMENT ON COLUMN public.sys_user_register.f_audit_user IS '审核人';
COMMENT ON COLUMN public.sys_user_register.f_audit_time IS '审核时间';
COMMENT ON COLUMN public.sys_user_register.f_createtime IS '注册时间';
COMMENT ON COLUMN public.sys_user_register.f_email IS '邮箱';
COMMENT ON COLUMN public.sys_user_register.f_password IS '密码';
COMMENT ON COLUMN public.sys_user_register.f_organization IS '组织id';
COMMENT ON COLUMN public.sys_user_register.f_region IS '辖区';

