/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.base.dto;

import com.google.gson.Gson;
import io.swagger.annotations.ApiModelProperty;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class BaseResponse {
    @ApiModelProperty(value="\u72b6\u6001\u6807\u8bb0", notes="OK\u3001FAILURE\u3001NEEDLOGIN")
    protected String status = "OK";
    @ApiModelProperty(value="\u72b6\u6001\u4fe1\u606f")
    protected String message = "";
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    protected Integer code = 200;

    public void markFailure() {
        this.status = "FAILURE";
        this.code = 1000;
    }

    public void markNoLogin() {
        this.status = "NEEDLOGIN";
        this.code = 1001;
    }

    public void markNoPermisson() {
        this.status = "FAILURE";
        this.code = 1002;
    }

    public static BaseResponse buildNoLoginResponse() {
        BaseResponse response = new BaseResponse();
        response.setStatus("NEEDLOGIN");
        response.setMessage("\u7528\u6237\u672a\u767b\u5f55\u6216\u5df2\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
        return response;
    }

    public static BaseResponse buildFailuaResponse(Exception e) {
        BaseResponse response = new BaseResponse();
        response.setStatus("FAILURE");
        response.setMessage(e.getMessage());
        return response;
    }

    public static BaseResponse buildFailuaResponse(String error) {
        BaseResponse response = new BaseResponse();
        response.setStatus("FAILURE");
        response.setMessage(error);
        return response;
    }

    public static BaseResponse buildFailuaResponse(String error, Integer code) {
        BaseResponse response = new BaseResponse();
        response.setStatus("FAILURE");
        response.setCode(code);
        response.setMessage(error);
        return response;
    }

    public static BaseResponse buildSuccessResponse() {
        BaseResponse response = new BaseResponse();
        response.setStatus("OK");
        return response;
    }

    public static BaseResponse buildSuccessResponse(String message) {
        BaseResponse response = new BaseResponse();
        response.setStatus("OK");
        response.setMessage(message);
        return response;
    }

    public void buildJsonResponse(HttpServletResponse httpResponse, BaseResponse response, Logger logger) {
        try {
            Gson gson = new Gson();
            String jsonResult = gson.toJson((Object)response);
            httpResponse.setContentType("application/json;charset=utf-8");
            httpResponse.getWriter().write(jsonResult);
            httpResponse.getWriter().flush();
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(status=" + this.getStatus() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ")";
    }
}

