/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.base.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.base.base.domain.RestResult;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseCrudController<T, S extends IService<T>> {
    protected final S service;
    protected final MyBatisQueryMapperUtils<T> qmu;

    public BaseCrudController(S s, T t) {
        this.service = s;
        this.qmu = new MyBatisQueryMapperUtils<T>(t);
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5185\u5bb9")
    @GetMapping(value={"/{id}"})
    public RestResult<T> queryById(@PathVariable String id) throws Exception {
        return RestResult.success(this.service.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u5355\u4e2a\u5185\u5bb9")
    @GetMapping(value={"/filter"})
    public RestResult<T> queryByFilter(String filterParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam);
        wrapper.last("limit 1");
        return RestResult.success(this.service.getOne(wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResult<List<T>> queryList(String filterParam, String sortParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        return RestResult.success(this.service.list(wrapper));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/page"})
    public RestResult<IPage<T>> queryList(String filterParam, String sortParam, Integer page, Integer size) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        return RestResult.success(this.service.page((IPage)pages, wrapper));
    }

    @ApiOperation(value="\u6839\u636eid\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdate"})
    public RestResult<String> saveOrUpdate(@RequestBody T t) throws Exception {
        this.service.saveOrUpdate(t);
        Map map = BeanUtil.beanToMap(t);
        return RestResult.success(map.get("id").toString());
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public RestResult<String> delete(@PathVariable String id) throws Exception {
        this.service.removeById((Serializable)((Object)id));
        return RestResult.success("\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636eids\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteByIds"})
    public RestResult<String> deleteBatch(@RequestParam String ids) throws Exception {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return RestResult.success("\u5220\u9664\u6210\u529f\uff01");
    }

    private QueryWrapper<T> getWrapper(String filterParam, String sortParam) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)filterParam) && StringUtils.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapper(filterParam, sortParam);
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            return this.qmu.queryMapper(filterParam);
        }
        if (StringUtils.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapperSort(sortParam);
        }
        return new QueryWrapper();
    }

    private QueryWrapper<T> getWrapper(String filterParam) throws Exception {
        return this.qmu.queryMapper(filterParam);
    }
}

