/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.support;

import java.net.InetAddress;
import org.apache.commons.lang3.RandomUtils;

public class SnowflakeIdWorker {
    private static final long twepoch = 1492153224787L;
    private static final long workerIdBits = 10L;
    private static final long maxWorkerId = 1023L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    static SnowflakeIdWorker instance;

    public SnowflakeIdWorker() {
        Long workId = this.getWorkId();
        this.workerId = this.workerId;
    }

    public SnowflakeIdWorker Instance() {
        if (instance == null) {
            instance = new SnowflakeIdWorker();
        }
        return instance;
    }

    public SnowflakeIdWorker(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 1023L));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1492153224787L << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    private Long getWorkId() {
        String ip = this.queryIpInfo();
        String[] ipArray = ip.split(".");
        Long workerId = 100L;
        workerId = ipArray.length == 4 ? Long.valueOf(Long.parseLong(ipArray[3])) : Long.valueOf(RandomUtils.nextLong((long)300L, (long)1023L));
        return workerId;
    }

    private String queryIpInfo() {
        String myip = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            myip = addr.getHostAddress().toString();
        }
        catch (Exception e) {
            myip = "127.0.0.1";
            e.printStackTrace();
        }
        return myip;
    }
}

