/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.exception.handler;

import com.geoway.design.base.base.dto.BaseResponse;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AccessDeniedException.class})
    public BaseResponse handleAccessDeniedException(AccessDeniedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u6743\u9650\u6821\u9a8c\u5931\u8d25'{}'", (Object)requestURI, (Object)e.getMessage());
        return BaseResponse.buildFailuaResponse("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743", HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public BaseResponse handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
        return BaseResponse.buildFailuaResponse(e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public BaseResponse handleServiceException(ServiceException e, HttpServletRequest request) {
        log.error(e.getMessage(), (Throwable)e);
        Integer code = e.getCode();
        return StringUtils.isNotNull(code) ? BaseResponse.buildFailuaResponse(e.getMessage(), code) : BaseResponse.buildFailuaResponse(e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public BaseResponse handleRuntimeException(RuntimeException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u672a\u77e5\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return BaseResponse.buildFailuaResponse(e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public BaseResponse handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return BaseResponse.buildFailuaResponse(e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public BaseResponse handleBindException(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25", (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return BaseResponse.buildFailuaResponse(message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResponse handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("\u8bf7\u6c42\u7684url\u4e3a{}\u51fa\u73b0\u6570\u636e\u6821\u9a8c\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:", (Object)request.getRequestURI(), (Object)e);
        BindingResult bindingResult = e.getBindingResult();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            errorMsgList.add(fieldError.getDefaultMessage());
        }
        String message = ((Object)errorMsgList).toString();
        return BaseResponse.buildFailuaResponse(message);
    }
}

