/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.support;

import com.geoway.design.base.support.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private ZipEntry zipEntry;
    private static int bufSize;
    private byte[] buf;
    private int readedBytes;
    private String rootDir;

    public ZipUtils() {
        this(512);
    }

    public ZipUtils(int bufSize) {
        ZipUtils.bufSize = bufSize;
        this.buf = new byte[ZipUtils.bufSize];
    }

    public void unZip(String unZipfileName) {
        block12: {
            if (unZipfileName.endsWith(".zip")) {
                String f = unZipfileName.substring(0, unZipfileName.length() - 4);
                String rootName = "";
                f = f.replaceAll("\\\\", "/");
                rootName = f.substring(f.lastIndexOf("/") + 1);
                File ff = new File(f);
                try {
                    File zipFile = new File(unZipfileName);
                    if (zipFile.exists()) {
                        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(unZipfileName)));
                        while ((this.zipEntry = zipIn.getNextEntry()) != null) {
                            String path = this.zipEntry.getName();
                            path = (path = path.replaceAll("\\\\", "/")).lastIndexOf("/") > -1 ? path.substring(0, path.lastIndexOf("/")) : "";
                            path = path.replaceFirst(rootName, "");
                            File file = new File(this.zipEntry.getName());
                            if (this.zipEntry.isDirectory()) {
                                file.mkdirs();
                            } else {
                                File parent = file.getParentFile();
                                if (parent != null && !parent.exists()) {
                                    parent.mkdirs();
                                }
                                if (!ff.exists()) {
                                    ff.mkdir();
                                }
                                File dir = null;
                                dir = StringUtils.isBlank((CharSequence)path) ? new File(f) : new File(f + "/" + path);
                                if (!dir.exists()) {
                                    dir.mkdirs();
                                }
                                FileOutputStream fileOut = StringUtils.isEmpty(path) ? new FileOutputStream(f + "/" + file.getName()) : new FileOutputStream(f + "/" + path + "/" + file.getName());
                                while ((this.readedBytes = zipIn.read(this.buf)) > 0) {
                                    fileOut.write(this.buf, 0, this.readedBytes);
                                }
                                fileOut.close();
                            }
                            zipIn.closeEntry();
                        }
                        System.out.println("\u89e3\u538b\u5b8c\u6210\uff01");
                        break block12;
                    }
                    System.err.println("zip\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
            } else {
                System.err.println("\u60a8\u9009\u62e9\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6\uff01");
            }
        }
    }

    public void doZip(String zipDirectory) {
        File zipDir = new File(zipDirectory);
        if (zipDir.exists()) {
            this.rootDir = zipDir.getName();
            String zipFileName = zipDirectory + ".zip";
            if (zipDir.isFile()) {
                zipFileName = zipDirectory.substring(0, zipDirectory.indexOf(".")) + ".zip";
            }
            try {
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                this.handleDir(zipDir, zipOut);
                zipOut.close();
                System.out.println("\u5b8c\u6210\uff01");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println(" \u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u4ef6\u8def\u5f84\uff01");
            }
        } else {
            System.err.println("\u60a8\u8f93\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
        }
    }

    public void doZip(String zipDirectory, String zipFileName) {
        File zipDir = new File(zipDirectory);
        if (zipDir.exists()) {
            try {
                this.rootDir = zipDir.getName();
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                this.handleDir(zipDir, zipOut);
                zipOut.close();
                System.out.println("\u5b8c\u6210\uff01");
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                System.out.println(" \u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u4ef6\u8def\u5f84\uff01");
            }
        } else {
            System.err.println("\u60a8\u8f93\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
        }
    }

    private void handleDir(File dir, ZipOutputStream zipOut) throws IOException {
        File[] files = null;
        if (dir.isDirectory()) {
            files = dir.listFiles();
            if (null != files && files.length == 0) {
                zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
                zipOut.closeEntry();
            } else {
                for (File fileName : files) {
                    if (fileName.isDirectory()) {
                        this.handleDir(fileName, zipOut);
                        continue;
                    }
                    FileInputStream fileIn = new FileInputStream(fileName);
                    String name = dir.getName();
                    String path = dir.getPath();
                    path = path.substring(path.indexOf(this.rootDir));
                    zipOut.putNextEntry(new ZipEntry(path + "/" + fileName.getName().toString()));
                    while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                        zipOut.write(this.buf, 0, this.readedBytes);
                    }
                    zipOut.closeEntry();
                }
            }
        } else if (dir.isFile()) {
            FileInputStream fileIn = new FileInputStream(dir);
            String name = dir.getName();
            String path = dir.getPath();
            zipOut.putNextEntry(new ZipEntry(dir.getName().toString()));
            while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                zipOut.write(this.buf, 0, this.readedBytes);
            }
            zipOut.closeEntry();
        }
    }
}

