package com.geoway.design.base.base.domain;

/**
 * 异常代码枚举类
 *
 * @author linkang
 * @version 1.0
 * @date 2022-05-19 15:52
 * @since JDK 1.8
 */
public enum ResultCodeEnum {
    /**
     * 异常代码枚举类
     */
    SUCCESS(true, 200, "成功"),
    UNKNOWN_ERROR(false, 500, "未知错误"),
    INSERT_ERROR(false, 1000, "插入数据异常"),
    SELECT_ERROR(false, 1001, "查询数据异常"),
    UPDATE_ERROR(false, 1002, "更新数据异常"),
    DELETE_ERROR(false, 1003, "删除数据异常"),
    NULL_POINT(false, 1004, "空指针异常"),
    INDEX_OUT_OF_BOUNDS(false, 1005, "下标越界异常"),
    REQUEST_TIMEOUT(false, 1006, "请求超时"),
    PARAM_ERROR(false, 1007, "参数错误"),
    NOT_INIT_DATA(false, 1008, "数据未初始化"),
    SQL_ERROR(false, 1009, "数据库SQL错误"),
    CUSTOM_ERROR(false, 2000, "自定义错误"),
    USER_FORBIDDEN(false, 2001, "用户被禁用"),
    NOT_LOGIN_ERROR(false, 2002, "未登录"),
    NEED_CHANGE_INIT_PWD(true, 2003, "需要修改初始密码");

    private final Boolean success;
    private final Integer code;
    private final String message;

    ResultCodeEnum(boolean success, Integer code, String message) {
        this.success = success;
        this.code = code;
        this.message = message;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}
