package com.geoway.design.base.base.dto;

import com.geoway.design.base.constants.CommonConstants;
import com.geoway.design.base.constants.StatusConstants;
import com.google.gson.Gson;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.slf4j.Logger;

import javax.servlet.http.HttpServletResponse;

/**
 * @author: linkang @Date: 2021/7/19 10:25 @Description:
 */
@Data
public class BaseResponse {
    @ApiModelProperty(value = "状态标记",notes = "OK、FAILURE、NEEDLOGIN")
    protected String status = CommonConstants.RESPONSE_STATUS_OK;

    @ApiModelProperty(value = "状态信息")
    protected String message = "";

    @ApiModelProperty(value = "状态码")
    protected Integer code = 200;

    public void markFailure() {
        this.status = CommonConstants.RESPONSE_STATUS_FAILURE;
        this.code = StatusConstants.FAILURE;
    }

    public void markNoLogin() {
        this.status = CommonConstants.RESPONSE_STATUS_LOGINOUT;
        this.code = StatusConstants.NOLOGIN;
    }

    public void markNoPermisson() {
        this.status = CommonConstants.RESPONSE_STATUS_FAILURE;
        this.code = StatusConstants.NOPERMISSON;
    }

    public static BaseResponse buildNoLoginResponse() {
        BaseResponse response = new BaseResponse();
        response.setCode( StatusConstants.FAILURE);
        response.setStatus(CommonConstants.RESPONSE_STATUS_LOGINOUT);
        response.setMessage("用户未登录或已登录超时，请重新登录!");
        return response;
    }

    public static BaseResponse buildFailuaResponse(Exception e) {
        BaseResponse response = new BaseResponse();
        response.setCode( StatusConstants.FAILURE);
        response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
        response.setMessage(e.getMessage());
        return response;
    }

    public static BaseResponse buildFailuaResponse(String error) {
        BaseResponse response = new BaseResponse();
        response.setCode( StatusConstants.FAILURE);
        response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
        response.setMessage(error);
        return response;
    }

    public static BaseResponse buildFailuaResponse(String error, Integer code) {
        BaseResponse response = new BaseResponse();
        response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
        response.setCode(code);
        response.setMessage(error);
        return response;
    }

    public static BaseResponse buildSuccessResponse() {
        BaseResponse response = new BaseResponse();
        response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
        return response;
    }

    public static BaseResponse buildSuccessResponse(String message) {
        BaseResponse response = new BaseResponse();
        response.setStatus(CommonConstants.RESPONSE_STATUS_OK);

        response.setMessage(message);
        return response;
    }

    public void buildJsonResponse(
            HttpServletResponse httpResponse, BaseResponse response, Logger logger) {
        try {
            Gson gson = new Gson();
            String jsonResult = gson.toJson(response);
            httpResponse.setContentType("application/json;charset=utf-8");
            httpResponse.getWriter().write(jsonResult);
            httpResponse.getWriter().flush();
        } catch (Exception ex) {
            logger.debug(ex.getMessage());
        }
    }
}
