package com.geoway.design.base.base.dto;

import com.geoway.design.base.constants.CommonConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = false)
@XmlRootElement(name = "BaseObjectResponse")
@XmlAccessorType(XmlAccessType.NONE)
@ApiModel("返回结果EasyUI表格列表模型")
public class EasyUIResponse extends BaseResponse{

	@XmlElement
	@ApiModelProperty(value = "状态标记")
	protected String status = CommonConstants.RESPONSE_STATUS_OK;

	@XmlElement
	@ApiModelProperty(value = "返回提示信息")
	protected String message = "";

	@XmlElement
	@ApiModelProperty(value = "总记录数")
	protected Long total = 0L;

	@XmlElement
	@ApiModelProperty(value = "总行数")
	List rows = null;

	@XmlElement
	@ApiModelProperty(value = "数据对象")
	Map map = null;

	public static EasyUIResponse buildNoLoginResponse() {
		EasyUIResponse response = new EasyUIResponse();

		response.setStatus(CommonConstants.RESPONSE_STATUS_LOGINOUT);
		response.setMessage("用户未登录或已登录超时，请重新登录!");

		return response;
	}

	public static EasyUIResponse buildFailuaResponse(Exception e) {
		EasyUIResponse response = new EasyUIResponse();
		response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
		response.setMessage(e.getMessage());
		return response;
	}

	public static EasyUIResponse buildFailuaResponse(String error) {
		EasyUIResponse response = new EasyUIResponse();
		response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
		response.setMessage(error);
		return response;
	}

	public static EasyUIResponse buildSuccessResponse(){
		EasyUIResponse response = new EasyUIResponse();
		response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
		return response;
	}

	public static EasyUIResponse buildSuccessResponse(String message){
		EasyUIResponse response = new EasyUIResponse();
		response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
		response.setMessage(message);
		return response;
	}

}
