package com.geoway.design.base.base.service;

import com.geoway.design.base.support.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;


/**
 * @author AA
 */
@Service
public class DbTimeService {
	
	@Autowired
    JdbcTemplate jdbcTemplate;
	
	String myDbType = "";
	
	public Date getCurrentTime(){
	    Date resultDate = null;
		try{
			String sql = "select now()";
			String dbType = queryDbType();
			if("postgresql".equalsIgnoreCase(dbType)||"mysql".equalsIgnoreCase(dbType)){
				sql = "select now()";
				SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sql);
				while(rowSet.next()){
					Timestamp timestamp = rowSet.getTimestamp(1);
					resultDate = new Date(timestamp.getTime());
					break;
				}
			}else if("oracle".equalsIgnoreCase(dbType)) {
				sql = "select sysdate from dual";
				SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sql);
				while(rowSet.next()){
					Timestamp timestamp = rowSet.getTimestamp(1);
					resultDate = new Date(timestamp.getTime());
					break;
				}
			}
			
		}catch(Exception ex){
			ex.printStackTrace();
		}
		
		if(resultDate == null){
			resultDate = new Date();
		}

		return resultDate;
	}
	
	public String queryDbType(){
		String dbType = "postgresql";
		if(StringUtils.isNotBlank(myDbType)){
			dbType = myDbType;
			return dbType;
		}
		Connection myConn = null;
		try{
			myConn = jdbcTemplate.getDataSource().getConnection();
			dbType = myConn.getMetaData().getDatabaseProductName();
			myDbType = dbType;
			
		}catch(Exception ex){
			ex.printStackTrace();
		}
		finally{
			if (myConn != null) {
				try {
					myConn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
		
		return dbType;
	}
}

