package com.geoway.design.base.enums;

/**
 * @author geoway
 */

public enum EnumServiceType {
    Data("数据服务", "DataService", 4),
    Analysis("分析服务", "AnalysisService", 5),
    Component("组件服务", "ComponentService", 5);
    public String description;
    public String type;
    public int value;
    EnumServiceType(String description, String type, int value){
        this.description = description;
        this.type = type;
        this.value = value;
    }
    public static EnumServiceType getEnumByValue(int type) {
        for(EnumServiceType typeIdEnum : EnumServiceType.values()){
            if(typeIdEnum.value == type){
                return typeIdEnum;
            }
        }
        return Data;
    }
}
