package com.geoway.design.base.enums.register;

import com.geoway.design.base.enums.servicemanager.EnumCheckStatus;

/**
 * @author ALMJ
 * @desc  注册用户类型枚举
 * @date 2022/10/21 12:53
 */
public enum EnumUserType {
    SYSTEM("系统用户", 0),
    NATURALPERSON("自然人", 1),
    LEGALPERSON("法人", 2),
    DEFAULT("默认",99);

    public String description;
    public Short value;
    EnumUserType(String description, int value){
        this.description = description;
        this.value = (short) value;
    }
    public static EnumUserType getEnumByValue(int type) {
        for(EnumUserType typeIdEnum : EnumUserType.values()){
            if(typeIdEnum.value == type){
                return typeIdEnum;
            }
        }
        return DEFAULT;
    }
}
