package com.geoway.design.base.enums.servicemanager;

/**
 * @description: 服务审批状态
 * @author: lsz
 * @create: 2021-08-06 17:27
 **/
public enum EnumCheckStatus {
    NotCheck("待审核", "待审核", 0),
    Pass("通过", "通过", 1),
    Reject("拒绝", "拒绝", 2);
    public String description;
    public String type;
    public int value;
    EnumCheckStatus(String description, String type, int value){
        this.description = description;
        this.type = type;
        this.value = value;
    }
    public static EnumCheckStatus getEnumByValue(int type) {
        for(EnumCheckStatus typeIdEnum : EnumCheckStatus.values()){
            if(typeIdEnum.value == type){
                return typeIdEnum;
            }
        }
        return NotCheck;
    }
}
