package com.geoway.design.base.enums.servicemanager;

/**
 * @description: 参数类型：输入还是输出
 * @author: lsz
 * @create: 2021-08-11 16:39
 **/
public enum EnumParamDirection {
    In("In", "In", 0),
    Out("Out", "Out", 1);
    public String description;
    public String type;
    public int value;
    EnumParamDirection(String description, String type, int value){
        this.description = description;
        this.type = type;
        this.value = value;
    }
    public static EnumParamDirection getEnumByValue(int type) {
        for(EnumParamDirection typeIdEnum : EnumParamDirection.values()){
            if(typeIdEnum.value == type){
                return typeIdEnum;
            }
        }
        return In;
    }
}
