package com.geoway.design.base.enums.servicemanager.auth;

/**
 * @author geoway
 */

public enum EnumAuthorizerResourceType {
    Data("数据服务", "DataService", 0),
    Analysis("分析服务", "AnalysisService", 1),
    Component("组件服务", "ComponentService", 2);

    public String description;
    public String type;
    public int value;
    EnumAuthorizerResourceType(String description, String type, int value){
        this.description = description;
        this.type = type;
        this.value = value;
    }
    public static EnumAuthorizerResourceType getEnumByValue(int type) {
        for(EnumAuthorizerResourceType typeIdEnum : EnumAuthorizerResourceType.values()){
            if(typeIdEnum.value == type){
                return typeIdEnum;
            }
        }
        return Data;
    }
}
