package com.geoway.design.base.exception;

import com.geoway.design.base.constants.CommonConstants;

/**
 * @author ALMJ
 * @desc 业务异常
 */
public final class ResetPasswordException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    /**
     * 错误码
     */
    private Integer code = CommonConstants.STATUS_RESETPASSWORD;

    /**
     * 错误提示
     */
    private String message;


    /**
     * 空构造方法，避免反序列化问题
     */
    public ResetPasswordException() {
    }

    public ResetPasswordException(String message) {
        this.message = message;
    }


    @Override
    public String getMessage() {
        return message;
    }

    public Integer getCode() {
        return code;
    }

    public ResetPasswordException setMessage(String message) {
        this.message = message;
        return this;
    }
}