package com.geoway.design.base.support;

import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import org.springframework.stereotype.Component;

/**
 * @author ALMJ
 * @desc Mybatis Plus 雪花id生成器，
 * 实体主键字段上加上 @TableId(type = IdType.ASSIGN_ID)即可生效
 * @date 2021/9/3 19:27
 */
@Component
public class MybatisIdGenerator implements IdentifierGenerator {
    private SnowflakeIdWorker worker = null;

    private SnowflakeIdWorker getWorker() {
        if (this.worker == null) {
            this.worker = new SnowflakeIdWorker();
        }
        return this.worker;
    }

    @Override
    public Number nextId(Object entity) {
        Long uid = this.getWorker().nextId();
        return uid;
    }

    @Override
    public String nextUUID(Object entity) {
        Long uid = this.getWorker().nextId();
        return uid.toString();
    }
}
