package com.geoway.design.base.support;

import lombok.extern.slf4j.Slf4j;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import java.lang.management.ManagementFactory;
import java.util.Set;

/**
 * @author linkang
 */
@Slf4j
public class TomcatUtil {
    public static String port = "";

    public static void getTomcatPort() throws MalformedObjectNameException {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames =
                beanServer.queryNames(
                        new ObjectName("*:type=Connector,*"),
                        Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        port = objectNames.iterator().next().getKeyProperty("port");
        log.info("当前tomcat的运行端口已获取成功！对应的端口为:{}", port);
    }
}
