/**
 *
 */
package com.geoway.design.base.support.listener;


import com.geoway.design.base.base.dto.FileUploadProgress;
import com.geoway.design.base.support.StringUtils;
import org.apache.commons.fileupload.ProgressListener;


import javax.servlet.http.HttpSession;

/**
 * 文件上传进度监听类
 * @author AA
 */
public class FileUploadProgressListener implements ProgressListener {

	private HttpSession session;
	public final static String UploadStatus = "upload-progress";

	private String uploadTag = "upload-progress";


	public FileUploadProgressListener(HttpSession session) {
	    this.session=session;
        FileUploadProgress progress = new FileUploadProgress();

        if(session.getAttribute("workId") != null){
        	this.uploadTag = session.getAttribute("workId").toString();
        }
        session.setAttribute(this.uploadTag, progress);
    }

	public FileUploadProgressListener(HttpSession session, String workId) {
	    this.session=session;
        FileUploadProgress progress = new FileUploadProgress();
        if(StringUtils.isNotBlank(workId)){
        	this.uploadTag = workId;
        }
        session.setAttribute(this.uploadTag, progress);
	 }

		/**
		 * pBytesRead 到目前为止读取文件的比特数 pContentLength 文件总大小 pItems 目前正在读取第几个文件
		 */
	@Override
	public void update(long pBytesRead, long pContentLength, int pItems) {
			FileUploadProgress status = (FileUploadProgress) session.getAttribute(this.uploadTag);
			status.setBytesRead(pBytesRead);
			status.setContentLength(pContentLength);
			status.setItems(pItems);
			session.setAttribute(this.uploadTag, status);
			//System.out.println(pItems + ":" + pBytesRead);
	}

}
