package com.geoway.design.base.support.query;

import com.geoway.design.base.support.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author geoway
 */
public class QueryParamParseUtil {
	
	public static final String complexFindKey = "#";

     /**
      * 带括号表达式
      * @param matchParam
      * @return
      */
	public static boolean isComplexExpession(String matchParam){
		String regex = "\\([^\\(\\)]+\\)";
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(matchParam);

        return matcher.find();
	}
	

	/**
	 * 解析嵌套表达式
	 * @param matchParam
	 * @param cacheMap
	 * @return
	 */
	public static QueryFilterParam parseComplexMatchParam(String matchParam, Map<String,String> cacheMap){
		if(!cacheMap.containsKey(matchParam)){
			return null;
		}
		String filterParam = cacheMap.get(matchParam);
		QueryFilterParam queryFilterParam = new QueryFilterParam();
		queryFilterParam.setExpression(matchParam);
	
		String[] paramPairs = filterParam.split(";");
		List<QueryFilterParam>  childrens = new ArrayList<QueryFilterParam>();
		QueryFilterParam subQueryParam = null;
		for (int i = 0; i < paramPairs.length; i++) {
			String subMatchParam = paramPairs[i];
			if (StringUtils.isBlank(subMatchParam) ) {
				continue;
			}
			
            if(subMatchParam.contains(QueryParamParseUtil.complexFindKey)){
            	//递归处理参数
            	 subQueryParam = parseComplexMatchParam(subMatchParam,cacheMap);		
			}else{
				 subQueryParam = parseMatchParam(subMatchParam);
			}
            
            childrens.add(subQueryParam);
		}
		
		queryFilterParam.setChildrens(childrens);
		queryFilterParam.setNest(true);
		
		if(childrens.size() > 0){
			queryFilterParam.setJoinModel(childrens.get(0).getJoinModel());
		}
		
		
		return queryFilterParam;
	}
	
	public static List<QueryFilterParam> parse4QueryParams(String filterParam) {

		List<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
		if (StringUtils.isBlank(filterParam) ) {
			return queryParams;
		}

		String[] paramPairs = filterParam.split(";");
		for (int i = 0; i < paramPairs.length; i++) {
			if (StringUtils.isBlank(paramPairs[i]) ) {
				continue;
			}

			queryParams.add(parseMatchParam(paramPairs[i]));
		}

		return queryParams;
	}
	
	public static QueryFilterParam parseMatchParam(String matchParam){
		
		QueryFilterParam queryParam = new QueryFilterParam();
		queryParam.setExpression(matchParam);
		
		String[] paramValPair = matchParam.split("=");
		String parseParam = paramValPair[0].trim();

		String[] fieldInfo = parseParam.split("_");

		// 设置连接条件
		String joinParam = fieldInfo[0];
		if (joinParam.toUpperCase().equals("Q") || joinParam.toUpperCase().equals("QA")) {
			queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
		} else if (joinParam.toUpperCase().equals("QOR")) {
			queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);
		}

		// 设置字段名称
		queryParam.setParamName(fieldInfo[1].trim());
		queryParam.setParamValue(paramValPair[1].trim());

		// 设置字段类型
		String fieldType = fieldInfo[2];
		if (fieldType.toUpperCase().equals("N")) {
			queryParam.setFieldType(QueryFilterParam.DataFieldType.NumberField);
		} else if (fieldType.toUpperCase().equals("S")) {
			queryParam.setFieldType(QueryFilterParam.DataFieldType.StringField);
		} else if (fieldType.toUpperCase().equals("D")) {
			queryParam.setFieldType(QueryFilterParam.DataFieldType.DateField);
		}

		// 设置操作符
		String operation = fieldInfo[3];
		queryParam.setOperation(operation);
		if (operation.toUpperCase().equals("EQ")) {
			queryParam.setOperationMode(OperationModel.EQ);
		} if (operation.toUpperCase().equals("NE")) {
			queryParam.setOperationMode(OperationModel.NE);
		} else if (operation.toUpperCase().equals("LK")) {
			queryParam.setOperationMode(OperationModel.LK);
		} else if (operation.toUpperCase().equals("LFK")) {
			queryParam.setOperationMode(OperationModel.LFK);
		} else if (operation.toUpperCase().equals("RHK")) {
			queryParam.setOperationMode(OperationModel.RHK);
		} else if (operation.toUpperCase().equals("BTW")) {
			queryParam.setOperationMode(OperationModel.BTW);
		} else if (operation.toUpperCase().equals("LT")) {
			queryParam.setOperationMode(OperationModel.LT);
		} else if (operation.toUpperCase().equals("GT")) {
			queryParam.setOperationMode(OperationModel.GT);
		} else if (operation.toUpperCase().equals("LE")) {
			queryParam.setOperationMode(OperationModel.LE);
		} else if (operation.toUpperCase().equals("GE")) {
			queryParam.setOperationMode(OperationModel.GE);
		} else if (operation.toUpperCase().equals("IN")) {
			queryParam.setOperationMode(OperationModel.IN);
		} else if (operation.toUpperCase().equals("NOTIN")) {
			queryParam.setOperationMode(OperationModel.NOTIN);
		} 
		return queryParam;
	}

}
