/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.base.controller;

import com.geoway.design.base.base.domain.AjaxResult;
import com.geoway.design.base.support.DateUtils;
import com.geoway.design.base.support.ServletUtils;
import com.geoway.design.base.support.StringUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtils.parseDate(text));
            }
        });
    }

    public HttpServletRequest getRequest() {
        return ServletUtils.getRequest();
    }

    public HttpServletResponse getResponse() {
        return ServletUtils.getResponse();
    }

    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? this.success() : this.error();
    }

    protected AjaxResult toAjax(boolean result) {
        return result ? this.success() : this.error();
    }

    public AjaxResult success() {
        return AjaxResult.success();
    }

    public AjaxResult error() {
        return AjaxResult.error();
    }

    public AjaxResult success(String message) {
        return AjaxResult.success(message);
    }

    public AjaxResult error(String message) {
        return AjaxResult.error(message);
    }

    public AjaxResult error(AjaxResult.Type type, String message) {
        return new AjaxResult(type, message);
    }

    public String redirect(String url) {
        return StringUtils.format("redirect:{}", url);
    }
}

