/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.base.config;

import com.geoway.design.base.support.StringUtils;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ServerConfig
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ServerConfig.class);
    @Value(value="${server.servlet.context-path}")
    private String contexPath;
    @Value(value="${server.port}")
    private String port;
    private String serverPort;

    public String getPort() {
        return this.port;
    }

    public String getContexPath() {
        return this.contexPath;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getUrl() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return "http://" + address.getHostAddress() + ":" + this.port + this.contexPath;
    }

    public String getHost() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return address.getHostAddress();
    }

    public String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        String serverPort = String.valueOf(event.getWebServer().getPort());
        if (StringUtils.isBlank((CharSequence)serverPort)) {
            serverPort = this.getTomcatPort();
        }
        this.serverPort = serverPort;
    }

    private String getTomcatPort() {
        String port = "";
        Set<ObjectName> objectNames = null;
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            port = objectNames.iterator().next().getKeyProperty("port");
            log.info("\u5f53\u524dtomcat\u7684\u8fd0\u884c\u7aef\u53e3\u5df2\u83b7\u53d6\u6210\u529f\uff01\u5bf9\u5e94\u7684\u7aef\u53e3\u4e3a:{}", (Object)port);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return port;
    }
}

