/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.gtdcbiz.config;

import java.util.Map;
import java.util.function.BiConsumer;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.ConcurrentReferenceHashMap;

@ConditionalOnProperty(name={"gac.oauth2.enable"}, havingValue="true")
@WebListener
public class GacHttpSessionListener
implements HttpSessionListener {
    private static Map<String, HttpSession> sessions = new ConcurrentReferenceHashMap();

    public static HttpSession getSessionBySessionId(String sessionId) {
        if (sessions.containsKey(sessionId)) {
            return sessions.get(sessionId);
        }
        return null;
    }

    public static void forEach(BiConsumer<String, HttpSession> action) {
        sessions.forEach(action);
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        sessions.put(session.getId(), session);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String sessionId = se.getSession().getId();
        try {
            sessions.remove(sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

