/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.gtdcbiz.controller;

import com.geoway.design.base.support.uuid.UUID;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.design.gtdcbiz.config.GacHttpSessionListener;
import com.geoway.design.gtdcbiz.service.GtdcUserSyncServiceImpl;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2UserInfo;
import com.geoway.landteam.platform.ucs.UcsRes3UserSdk;
import com.geoway.landteam.platform.ucs.res3user.api.user.reso.EpaUserInfoReso;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import com.gw.base.Gw;
import com.gw.base.util.GutilObject;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u56fd\u571f\u8c03\u67e5\u4e91\u5355\u70b9\u767b\u5165"})
@Controller
@RequestMapping(value={"/gtySSO"})
public class GtyLoginController {
    private static final Logger log = LoggerFactory.getLogger(GtyLoginController.class);
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private GtdcUserSyncServiceImpl gtdcUserSyncService;

    @ApiIgnore
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, String redirect_url) throws Exception {
        redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
        HttpSession session = request.getSession(true);
        Object user = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
        if (user == null) {
            AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
            String state = UUID.randomUUID().toString();
            URI uri = sso.getAuthorizationRequestURIWithState(state);
            session.setAttribute(state, (Object)redirect_url);
            redirect_url = uri.toString();
        } else {
            GacOauth2UserInfo userInfo = (GacOauth2UserInfo)user;
            redirect_url = this.authRedirectUri(redirect_url, userInfo.getAccessToken());
        }
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    @ApiIgnore
    @GetMapping(value={"/loginProcessing"})
    public String loginProcessing(HttpServletRequest request, HttpServletResponse httpResponse, String code, String state) throws Exception {
        AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
        HttpSession session = request.getSession(true);
        String sessionId = session.getId();
        OAuth2AuthorizedClient cd = sso.authentication(sessionId, code, state);
        GacOauth2UserInfo userInfo = sso.getOAuth2UserInfo(sessionId);
        session.setAttribute(GacOauth2UserInfo.class.getSimpleName(), (Object)userInfo);
        SsoUser ssoUser = new SsoUser();
        SysUser user = this.sysUserService.queryOne(userInfo.getUserId());
        if (user == null) {
            this.gtdcUserSyncService.syncUserInfoByUserName(userInfo.getUserName());
            user = this.sysUserService.queryOne(userInfo.getUserId());
        }
        List regions = this.sysRegionMapper.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        EpaUserInfoReso epaUserInfoReso = UcsRes3UserSdk.getEpaUserSelectRes3UserService().getUserInfo();
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getName());
        ssoUser.setLoginName(user.getAname());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setToken(userInfo.getAccessToken());
        String tgt = this.ticketGrantingTicketManager.generate(ssoUser);
        CodeContent codeContent = new CodeContent(tgt, false, null);
        AccessTokenContent authDto = new AccessTokenContent(codeContent, ssoUser, this.projectConfig.getSsoAppId(), null);
        String redirect_url = (String)session.getAttribute(state);
        redirect_url = URLDecoder.decode(redirect_url, "UTF-8");
        redirect_url = this.authRedirectUri(redirect_url, userInfo.getAccessToken());
        this.genereateRpcAccessToken(authDto, "");
        log.error("\u56de\u8c03\u5730\u5740\uff1aredirect:" + redirect_url);
        return "redirect:" + redirect_url;
    }

    private String authRedirectUri(String redirectUri, String code) throws UnsupportedEncodingException {
        StringBuilder sbf = new StringBuilder(redirectUri);
        if (redirectUri.indexOf("?") > -1) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append("token").append("=").append(code);
        return URLDecoder.decode(sbf.toString(), "utf-8");
    }

    private RpcAccessToken genereateRpcAccessToken(AccessTokenContent accessTokenContent, String accessToken) {
        String newAccessToken = accessToken;
        if (newAccessToken == null || !this.accessTokenManager.refresh(newAccessToken)) {
            newAccessToken = this.accessTokenManager.generate(accessTokenContent);
        }
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, newAccessToken);
        AccessTokenContent tokenContent = this.accessTokenManager.get(newAccessToken);
        tokenContent.setRefreshToken(refreshToken);
        this.accessTokenManager.create(newAccessToken, tokenContent);
        return new RpcAccessToken(newAccessToken, this.accessTokenManager.getExpiresIn(), refreshToken, accessTokenContent.getUser());
    }

    @PostMapping(value={"/notifyLogout"})
    @ResponseBody
    public String notifyLogout(@RequestParam(value="access_token") String access_token) {
        Gw.log.info("\u6536\u5230\u4e86\u88ab\u52a8\u767b\u51fa\u8bf7\u6c42\uff0caccess_token:{}", new Object[]{access_token});
        GacHttpSessionListener.forEach((sessionId, session) -> {
            try {
                Object gacOauth2UserObject = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
                if (gacOauth2UserObject != null) {
                    GacOauth2UserInfo gacOauth2User = (GacOauth2UserInfo)gacOauth2UserObject;
                    Gw.log.info("\u4f1a\u8bdd\u7528\u6237\u7684\uff0caccess_token:{}", new Object[]{gacOauth2User.getAccessToken()});
                    if (GutilObject.equals((Object)gacOauth2User.getAccessToken(), (Object)access_token)) {
                        Gw.log.info("\u83b7\u53d6\u5230\u6709\u4e00\u4e2a\u4f1a\u8bdd\u9700\u8981\u88ab\u6ce8\u9500\uff0csessionId:{}", new Object[]{session.getId()});
                        Oauth2Utils.revokeAccessToken((String)this.projectConfig.getSsoServerUrl(), (String)access_token);
                        session.removeAttribute(GacOauth2UserInfo.class.getSimpleName());
                        session.invalidate();
                    }
                }
            }
            catch (Exception e) {
                Gw.log.error((Throwable)e);
            }
        });
        return "OK";
    }
}

