/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.gtdcbiz.service;

import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.service.dev.impl.LocalLoginServiceImpl;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.design.gtdcbiz.service.GtdcUserServiceImpl;
import com.geoway.design.gtdcbiz.service.GtdcUserSyncServiceImpl;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.PasswordClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2AuthenticationException;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2UserInfo;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.gw.base.Gw;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GtdcLoginServiceImpl
extends LocalLoginServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(GtdcLoginServiceImpl.class);
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private GtdcUserServiceImpl gtdcUserService;
    @Autowired
    private GtdcUserSyncServiceImpl gtdcUserSyncService;
    @Autowired
    private PasswordUtil passwordUtil;

    public String getLoginType() {
        return "1";
    }

    public Result<SsoUser> login(String username, String password, String tel, String uuid, String code, HttpServletRequest req) {
        this.validateCaptcha(uuid, code);
        Result<SsoUser> ssoUserResult = this.loginByGtdc(username, password, tel, uuid, code, req);
        return ssoUserResult;
    }

    private Result<SsoUser> loginByGtdc(String username, String password, String tel, String uuid, String code, HttpServletRequest req) {
        try {
            PasswordClientRegistration passwordClientRegistration = GacOauth2Tool.getGasPasswordClientRegistration();
            OAuth2AuthorizedClient oAuth2AuthorizedClient = passwordClientRegistration.authentication(username, this.passwordUtil.getRealPassword(password));
            GacOauth2UserInfo gacOauth2UserInfo = passwordClientRegistration.getOAuth2UserInfo(username);
            SysUser gtdcUser = this.gtdcUserService.getSysUser(username);
            SysUser user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)gtdcUser.getId()));
            if (user == null) {
                this.gtdcUserSyncService.syncUserInfoByUserName(username);
                user = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)gtdcUser.getId()));
            }
            HttpSession session = req.getSession(true);
            session.setAttribute(GacOauth2UserInfo.class.getSimpleName(), (Object)gacOauth2UserInfo);
            SsoUser ssoUser = new SsoUser();
            List regions = this.sysRegionMapper.queryUserRegions(user.getId());
            String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
            String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
            ssoUser.setId(user.getId());
            ssoUser.setUserid(user.getId());
            ssoUser.setUserName(user.getAname());
            ssoUser.setLoginName(user.getAccout());
            ssoUser.setRegionCode(regionCode);
            ssoUser.setRegionName(regionName);
            ssoUser.setCatalog(user.getCatalog());
            ssoUser.setToken(oAuth2AuthorizedClient.getAccessToken().getTokenValue());
            return Result.createSuccess((Object)ssoUser);
        }
        catch (OAuth2AuthenticationException exception) {
            log.error(exception.getError().getErrorCode(), (Throwable)exception);
            return Result.createError((String)exception.getError().getErrorCode());
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return Result.createError((String)exception.getMessage());
        }
    }

    public boolean loginOut(HttpServletRequest request, String access_token) {
        try {
            HttpSession session = request.getSession(false);
            if (session != null) {
                Object user = session.getAttribute(GacOauth2UserInfo.class.getSimpleName());
                if (user != null) {
                    AuthorizationCodeClientRegistration sso = GacOauth2Tool.getGasAuthorizationCodeClientRegistration();
                    sso.revokeAuthentication(session.getId());
                }
                try {
                    session.invalidate();
                }
                catch (Exception e) {
                    Gw.log.error((Throwable)e);
                }
                Gw.log.info("\u8c03\u7528session.invalidate()", new Object[0]);
            }
            return true;
        }
        catch (Exception exception) {
            Gw.log.error((Throwable)exception);
            return true;
        }
    }
}

