/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.gtdcbiz.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.biz.dto.UserSyncDTO;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserOrganization;
import com.geoway.design.biz.entity.SysUserRegion;
import com.geoway.design.biz.service.dev.impl.AbstractUserSyncService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.gtdcbiz.service.GtdcUserServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GtdcUserSyncServiceImpl
extends AbstractUserSyncService {
    @Autowired
    private ISysUserRegionService sysUserRegionService;
    @Autowired
    private GtdcUserServiceImpl gtdcUserService;

    @Transactional
    public String syncUserInfo(UserSyncDTO userInfo) {
        if (userInfo == null) {
            return "\u65e0\u7528\u6237\u4fe1\u606f\u9700\u8981\u540c\u6b65\uff01";
        }
        List<Object> stockUserIds = new ArrayList();
        int userNumber = 0;
        if (userInfo.getUsers() != null) {
            LambdaQueryWrapper userWarpper = Wrappers.lambdaQuery();
            userWarpper.eq(SysUser::getSource, (Object)"gtdc");
            stockUserIds = this.localUserService.list((Wrapper)userWarpper).stream().map(f -> f.getId()).collect(Collectors.toList());
            userNumber = userInfo.getUsers().size();
            this.localUserService.remove((Wrapper)userWarpper);
            this.localUserService.saveBatch((Collection)userInfo.getUsers());
        }
        int orgNumber = 0;
        if (userInfo.getOrgs() != null) {
            orgNumber = userInfo.getOrgs().size();
            LambdaQueryWrapper orgWarpper = Wrappers.lambdaQuery();
            orgWarpper.eq(SysOrganization::getSource, (Object)"gtdc");
            this.localOrganizationService.remove((Wrapper)orgWarpper);
            this.localOrganizationService.saveBatch((Collection)userInfo.getOrgs());
        }
        int userOrgs = 0;
        if (userInfo.getUserOrgs() != null) {
            if (stockUserIds.size() > 0) {
                List idGroups = Lists.partition(stockUserIds, (int)1000);
                for (List ids : idGroups) {
                    LambdaQueryWrapper userOrgWarpper = Wrappers.lambdaQuery();
                    userOrgWarpper.in(SysUserOrganization::getUserid, (Collection)ids);
                    this.localUserOrganizationService.remove((Wrapper)userOrgWarpper);
                }
            }
            userOrgs = userInfo.getUserOrgs().size();
            this.localUserOrganizationService.saveBatch(userInfo.getUserOrgs());
        }
        int userRegion = 0;
        if (userInfo.getUserRegions() != null) {
            userRegion = userInfo.getUserRegions().size();
            if (stockUserIds.size() > 0) {
                List idGroups = Lists.partition(stockUserIds, (int)1000);
                for (List ids : idGroups) {
                    LambdaQueryWrapper userRegionWarpper = Wrappers.lambdaQuery();
                    userRegionWarpper.in(SysUserRegion::getUserid, (Collection)ids);
                    this.sysUserRegionService.remove((Wrapper)userRegionWarpper);
                }
            }
            this.sysUserRegionService.saveBatch((Collection)userInfo.getUserRegions());
        }
        return String.format("\u603b\u5171\u540c\u6b65\u4e86\uff1a%s\u4e2a\u7528\u6237,%s\u4e2a\u7ec4\u7ec7\u673a\u6784\uff0c%s\u4e2a\u7528\u6237-\u7ec4\u7ec7\u673a\u6784\u5173\u7cfb,%s\u4e2a\u7528\u6237\u884c\u653f\u533a", userNumber, orgNumber, userOrgs, userRegion);
    }

    public void syncUserInfoByUserName(String userName) {
        UserSyncDTO userInfo = this.gtdcUserService.getUserInfo(userName);
        if (userInfo.getUsers() != null) {
            this.localUserService.saveOrUpdateBatch((Collection)userInfo.getUsers());
        }
        if (userInfo.getOrgs() != null) {
            this.localOrganizationService.saveOrUpdateBatch((Collection)userInfo.getOrgs());
        }
        if (userInfo.getUserOrgs() != null) {
            this.localUserOrganizationService.saveOrUpdateBatch((Collection)userInfo.getUserOrgs());
        }
        if (userInfo.getUserRegions() != null) {
            this.sysUserRegionService.saveOrUpdateBatch((Collection)userInfo.getUserRegions());
        }
    }

    public UserSyncDTO getUserInfo() {
        return this.gtdcUserService.getUserInfo();
    }

    public String getType() {
        return "1";
    }
}

