package com.geoway.design.biz.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @TableName sys_user
 */
@TableName(value = "sys_user")
@Data
public class BimUser implements Serializable {

    /**
     *
     */
    @TableId(value = "f_id", type = IdType.INPUT)
    private String id;

    /**
     *
     */
    @Excel(name = "姓名(必填)", orderNum = "0")
    @TableField(value = "f_name")
    private String name;

    /**
     *
     */
    @TableField(value = "f_aname")
    private String aname;

    /**
     *
     */
    @Excel(name = "账户名(必填)", orderNum = "2")
    @TableField(value = "f_accout")
    private String accout;


    /**
     *
     */
    @Excel(name = "手机(必填)", orderNum = "4")
    @TableField(value = "f_tel")
    private String tel;

    /**
     * 加密的手机号
     */
    @TableField(value = "f_tel_encrypt")
    private String telEncrypt;

    /**
     * 用户分类，1系统管理员，2业务管理员，3普通用户
     */
    @TableField(value = "f_catalog")
    private Integer catalog = 3;

    /**
     *
     */
    @Excel(name = "邮箱", orderNum = "6")
    @TableField(value = "f_email")
    private String email;

    /**
     *
     */
    @Excel(name = "性别", orderNum = "8", replace = {"男_0", "_null", "女_1"})
    @TableField(value = "f_sex")
    private int sex;

    /**
     *
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     *
     */
    @TableField(value = "f_updatetime", fill = FieldFill.UPDATE)
    private Date updatetime;


    /**
     * 用户来源
     */
    @Excel(name = "用户来源", orderNum = "10")
    @TableField(value = "f_source")
    private String source = "第三方用户";

}