package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * @TableName sys_biz_manager_range
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value ="sys_biz_manager_range")
@Data
public class BizManagerRange implements Serializable {
    /**
     * id
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 用户id
     */
    @TableField(value = "f_userid")
    private String userid;

    /**
     * 管理类型，1辖区，2组织，3角色，4权限
     */
    @TableField(value = "f_manage_type")
    private Integer manageType;

    /**
     * 管理对象的值
     */
    @TableField(value = "f_manage_value")
    private String manageValue;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}