package com.geoway.design.biz.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @TableName sys_role
 */
@TableName(value = "sys_role")
@Data
public class SysRole implements Comparable<SysRole>, Serializable {

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     *
     */
    @TableField(value = "f_name", insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String name;

    /**
     *
     */
    @TableField(value = "f_key", insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String key;

    /**
     *
     */
    @TableField(value = "f_level")
    private Integer level;

    /**
     *
     */
    @TableField(value = "f_pid")
    private String pid;

    /**
     *
     */
    @TableField(value = "f_type")
    private Integer type;

    /**
     *
     */
    @TableField(value = "f_createtime",fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     *
     */
    @TableField(value = "f_parents")
    private String parents;


    @TableField(value = "f_allname")
    private String allname;

    /**
     *
     */
    @TableField(value = "f_bz")
    private String bz;


    /**
     *排序
     */
    @TableField(value = "f_sort")
    private Integer sort;

    @TableField(exist = false)
    private List<SysRole> children;

    @Override
    public int compareTo(SysRole o) {
        Integer iResult = 0;
        if (o.level != null && this.level != null) {
            iResult = this.level.compareTo(o.level);
        }
        return iResult;
    }
}