package com.geoway.design.biz.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.vo.SysMenuVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author daidongdong
 * @description 针对表【sys_menu】的数据库操作Mapper
 * @createDate 2022-03-10 10:51:01
 * @Entity com.geoway.ns.design.biz.entity.SysMenu
 */
@Repository
public interface SysMenuMapper extends BaseMapper<SysMenu> {


    /**
     * 查询用户所属的菜单
     *
     * @param userId
     * @param systemId
     * @return
     */
    List<SysMenu> queryUserSystemMenu(@Param("userId") String userId, @Param("systemId") String systemId, @Param("group") int group);

    List<SysMenu> querySystemMenu(@Param("systemId") String systemId, @Param("group") int group);

    /**
     * 查询免登录菜单
     * @param systemId
     * @param group
     * @return
     */
    List<SysMenu> querySystemMenuNoLogin(@Param("systemId") String systemId, @Param("group") int group);

    /**
     * 按用户查询授权菜单中的系统id
     *
     * @param userId 用户id
     * @return
     */
    List<String> queryUserMenuSystemId(@Param("userId") String userId);

    /**
     * 获取菜单权限
     *
     * @param roleIdList 角色id
     * @return {@link List}<{@link SysMenuVO}>
     */
    List<SysMenuVO> getSysMenuVO(@Param("roleIdList") List<String> roleIdList);

    /**
     * 通过IDList获取菜单
     *
     * @param idList 菜单id
     * @return {@link List}<{@link SysMenu}>
     */
    List<SysMenu> queryByIds(@Param("idList") List<String> idList);
}



