package com.geoway.design.biz.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.geoway.design.biz.entity.SysRegion;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_region】的数据库操作Mapper
* @createDate 2022-01-20 15:42:06
* @Entity com.geoway.ns.design.biz.entity.SysRegion
*/
@Repository
public interface SysRegionMapper extends BaseMapper<SysRegion> {

    /**
     * 查询用户关联组织机构
     * @param userId
     * @return
     */
    List<SysRegion> queryUserRegions(String userId);

    /**
     * 按照代码递归查询其下所有辖区
     * @return
     */
    List<SysRegion> getRegionListByCode(String regionCode);

    /**
     * 按照代码递归查询其上级区划
     * @return
     */
    List<SysRegion> getAllParentRegion(String regionCode);
}




