package com.geoway.design.biz.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.geoway.design.biz.entity.SysRole;
import com.geoway.design.biz.vo.SysRoleVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author daidongdong
 * @description 针对表【sys_role】的数据库操作Mapper
 * @createDate 2021-12-23 17:56:00
 * @Entity com.geoway.ns.design.biz.entity.SysRole
 */
@Repository
public interface SysRoleMapper extends BaseMapper<SysRole> {

    /**
     * 查询用户关联角色
     *
     * @param userId
     * @return
     */
    List<SysRole> queryUserRoles(String userId);

    /**
     * 得到系统角色签证官
     *
     * @param userId 用户id
     * @return {@link List}<{@link SysRoleVO}>
     */
    List<SysRoleVO> getSysRoleVO(@Param("userId") String userId);

    List<SysRole> getAllParentRole(String id);
}




