package com.geoway.design.biz.service.dev;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysUser;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_organization】的数据库操作Service
* @createDate 2021-12-02 17:19:38
*/

public interface IOrganizationService {

    /**
     * 保存与编辑
     * @param
     * @throws Exception
     */
    void saveOrUp(SysOrganization org) throws Exception;

    /**
     * 批量保存
     * @param
     * @throws Exception
     */
    void batchSave(List<SysOrganization> orgs) throws Exception;

    /**
     * 查询角色的树状结构
     * @return
     */
    List<SysOrganization> queryTree(String filterParam) throws Exception;

    /**
     * 不绑定用户，只查询机构目录树
     * @param filterParam
     * @return
     * @throws Exception
     */
    List<SysOrganization> queryTreeNoUser(String filterParam) throws Exception;

    /**
     * 根据过滤条件列表
     * @return
     */
    List<SysOrganization> queryList(String filterParam) throws Exception;

    /**
     * 按机构id递归查询其下所有机构
     * @param id
     * @return
     * @throws Exception
     */
    List<SysOrganization> queryListById(String id) throws Exception;

    /**
     * 按机构ID查询其所有上级机构
     * @param id
     * @return
     */
    List<SysOrganization> queryAllParentOrg(String id);

    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysOrganization> queryPage(String filterParam, int page, int size) throws Exception;


    /**
     * 查询组织机构信息（含直属子节点）
     * @param id
     * @param filterParam
     * @return
     */
    SysOrganization findOneById(String id, String filterParam) throws Exception;

    /**
     * 查询组织机构信息（含直属子节点）
     * @param name
     * @return
     */
    SysOrganization findOneByName(String name,String filterParam) throws Exception;
    /**
     * 批量删除
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids) throws Exception;


    /**
     * 部门和用户相关联
     * @param orgId
     * @param userIds
     */
    void bindUsers(String orgId,String userIds);

    /**
     * 添加一个用户
     * @param orgId
     * @param userId
     */
    void bindOneUser(String orgId,String userId);

    /**
     * 移除部门关联的用户
     * @param orgId
     * @param userIds
     */
    void removeBindUser(String orgId,String userIds);

    /**
     * 查询部门关联的用户信息
     * @param orgId
     * @return
     */
    List<SysUser> queryRelUsers(String orgId);

    /**
     * 查询所有无机构用户列表
     * @return
     */
    @Transactional
    List<SysUser> queryNonOrgUsers();

    /**
     * 查询角色的数量
     * @param filterParam
     * @return
     */
     int queryCount(String filterParam) throws Exception;
    /**
     * 查询用户关联组织机构
     *
     * @param userId
     * @return
     */
     List<SysOrganization> queryUserOrgs(String userId);

    /**
     * 绑定用户到区划
     * @param list
     */
    void bindUsersToOrg(List<SysOrganization> list);

    /**
     * 构造树
     * @param list
     * @return
     */
    List<SysOrganization> constructTree(List<SysOrganization> list);
}
