package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.service.dev.ILoginService;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;

/**
 * @author 连世忠
 * @ClassName AbstractLoginServiceImpl
 * @Description TODO
 * @date 2024/3/14 15:01
 * @Version 1.0
 */
public  abstract class AbstractLoginServiceImpl implements ILoginService {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private ICaptchaService commonService;

    @Override
    public String getLoginType() {
        return "0";
    }

    @Override
    public abstract Result<SsoUser> login(String username, String password,String tel, String uuid, String code, HttpServletRequest req);

    @Override
    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        return login(username, password, "", uuid,  code,  req);
    }
    @Override
    public Result<SsoUser> login(String username, String password) {

        Result<SsoUser>  result = login(username,password,null,null,null,null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        SessionUtils.invalidate(request);
        Result<RpcAccessToken> result = Oauth2Utils.revokeAccessToken(projectConfig.getSsoServerUrl(),access_token);
        return result.isSuccess();
    }

    protected void validateCaptcha(String uuid,String code){
        if(StrUtil.isEmpty(uuid)&&StrUtil.isEmpty(code)){
            return;
        }
        // 获取session中验证码
        String captcha = commonService.queryCaptcha(uuid);
        if (!commonService.validateCaptcha(code, captcha)) {
            throw new RuntimeException("验证码已过期或有误，请重新试试!");
        }
    }
}
