package com.geoway.design.biz.service.dev.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.biz.entity.SysOrganization;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.mapper.SysOrganizationMapper;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author daidongdong
 * @description 针对表【sys_organization】的数据库操作Service实现
 * @createDate 2021-12-02 17:19:38
 */

public abstract class AbstractOrganizationServiceImpl implements IOrganizationService {

    @Override
    public abstract List<SysOrganization> queryTree(String filterParam) throws Exception;

    @Override
    public abstract List<SysOrganization> queryTreeNoUser(String filterParam) throws Exception ;

    @Override
    public abstract List<SysOrganization> queryList(String filterParam) throws Exception ;

    @Override
    public abstract List<SysOrganization> queryListById(String id) throws Exception ;

    @Override
    public abstract IPage<SysOrganization> queryPage(String filterParam, int page, int size) throws Exception;

    @Override
    public abstract SysOrganization findOneById(String id, String filterParam) throws Exception;

    @Override
    public abstract SysOrganization findOneByName(String name, String filterParam) throws Exception;


    @Override
    public void saveOrUp(SysOrganization org) throws Exception {
        throw new RuntimeException("暂不支持组织机构的编辑");
    }

    @Override
    public void batchSave(List<SysOrganization> orgs) throws Exception {
        for (SysOrganization org : orgs) {
            this.saveOrUp(org);
        }
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        throw new RuntimeException("暂不支持组织机构的编辑");
    }


    @Override
    public void bindUsers(String orgId, String userIds) {
        throw new RuntimeException("暂不支持组织机构的编辑");
    }

    @Override
    public void bindOneUser(String orgId, String userId) {
        throw new RuntimeException("暂不支持组织机构的编辑");
    }

    @Override
    public void removeBindUser(String orgId, String userIds) {
        throw new RuntimeException("暂不支持组织机构的编辑");
    }

    @Override
    public List<SysUser> queryRelUsers(String orgId) {
        return null;
    }

    @Override
    public List<SysUser> queryNonOrgUsers() {
        return null;
    }

    @Override
    public int queryCount(String filterParam) throws Exception {
        return 0;
    }

    @Override
    public List<SysOrganization> queryUserOrgs(String userId) {
        return null;
    }
}




