package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysPermission;
import com.geoway.design.biz.entity.SysUserOrganization;
import com.geoway.design.biz.mapper.SysUserOrganizationMapper;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_organization】的数据库操作Service实现
* @createDate 2021-12-20 17:11:24
*/

public abstract class AbstractUserOrganizationServiceImpl implements IUserOrganizationService {

    @Override
    public void updateUserOrg(String userId, List<String> orgIds) {
       throw new RuntimeException("暂不支持用户组织机构的编辑");
    }

    @Override
    public void updateOrgUsers(String orgId, List<String> userIds) {
        throw new RuntimeException("暂不支持用户组织机构的编辑");
    }

    @Override
    public void saveBatch(List<SysUserOrganization> userOrgs) {
        for(SysUserOrganization userOrg:userOrgs){
            saveOne(userOrg);
        }
    }

    @Override
    public void saveOne(SysUserOrganization userOrg) {
        throw new RuntimeException("暂不支持用户组织机构的编辑");
    }

    @Override
    public void removeByOrgUserId(String orgId,String userId) {
        throw new RuntimeException("暂不支持用户组织机构的编辑");
    }

    @Override
    public abstract List<SysUserOrganization> queryByOrgId(String orgId);

    @Override
    public abstract List<SysUserOrganization> queryList(String filterParam);
}




