package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.exception.ServiceException;
import com.geoway.design.base.support.StringUtils;
import com.geoway.design.biz.dto.UserRelParams;
import com.geoway.design.biz.entity.*;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.dev.IUserService;
import com.geoway.design.biz.service.sys.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @author 连世忠
 * @ClassName AbstractUserServiceImpl
 * @Description TODO
 * @date 2024/3/13 15:13
 * @Version 1.0
 */
@Slf4j
public abstract class AbstractUserServiceImpl implements IUserService {
    @Autowired
    private ISysUserRoleService sysUserRoleService;

    @Autowired
    private IUserOrganizationService sysUserOrganizationService;

    @Autowired
    private ISysUserRegionService sysUserRegionService;

    @Override
    public abstract SysUser query(String userId);
    @Override
    public abstract List<SysUser> query(List<String> userId);
    @Override
    public abstract List<SysUser> queryList(String filterParam);
    @Override
    public abstract IPage<SysUser> queryPage(String filterParam, int page, int size);

    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto){
        throw new RuntimeException("暂不支持修改和保存用户");
    }

    @Override
    public void batchSave(List<SysUser> users)  {
        for (SysUser user : users) {
            this.saveOrUp(user,null,false);
        }
    }

    /**
     * 直接修改用户密码，无需校验旧密码
     *
     * @param userId
     * @param password
     */
    @Override
    public  void changePassword(String userId, String password){
        throw new RuntimeException("暂不支持修改用户密码");
    }
    @Override
    public void delete(String id){
        throw  new RuntimeException("暂不支持删除用户");
    }

    @Override
    public void batchDelete(String ids)  {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for(String id:idList) {
            this.delete(id);
        }
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        throw  new RuntimeException("暂不支持用户导出");
    }
    /**
     * 用户Excel批量导入
     *
     * @param userList        用户列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     * @throws Exception
     */
    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport) {
        throw  new RuntimeException("暂不支持用户批量导入");
    }

    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        throw  new RuntimeException("暂不支持修改用户密码");
    }


    protected void saveUserRelInfo(SysUser user){
        String otherParams = user.getOtherParams();
        if (StringUtils.isNotBlank(otherParams)) {
            try {
                UserRelParams userParams = JSON.parseObject(otherParams, UserRelParams.class);
                sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
                sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
                sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
            } catch (Exception ex) {
                throw new ServiceException("错误:" + ex.getMessage());
            }
//            UserRelParams userParams = JSON.parseObject(otherParams, UserRelParams.class);
//            if (userParams.getRoles() != null && userParams.getRoles().size() > 0) {
//                sysUserRoleService.updateUserRole(user.getId(), userParams.getRoles());
//            }
//            if (userParams.getOrganizations() != null && userParams.getOrganizations().size() > 0) {
//                sysUserOrganizationService.updateUserOrg(user.getId(), userParams.getOrganizations());
//            }

//            if (userParams.getRegions() != null && userParams.getRegions().size() > 0) {
//                sysUserRegionService.updateUserRegions(user.getId(), userParams.getRegions());
//            }
        }
    }


}
