package com.geoway.design.biz.service.dev.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.support.encryption.AESUtils;
import com.geoway.design.biz.entity.SysRegion;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysRegionMapper;
import com.geoway.design.biz.mapper.SysUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.util.PasswordUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.constant.TableFileds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author ALMJ
 * @desc 用户登录验证逻辑(本地登录)
 */
@Service("userService")
public class LocalLoginServiceImpl extends AbstractLoginServiceImpl {

    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysUserSecurityMapper sysUserSecurityMapper;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private PasswordUtil passwordUtil;
    @Override
    public Result<SsoUser> login(String username, String password,String tel, String uuid, String code, HttpServletRequest req) {
        //校验验证码
        validateCaptcha(uuid,code);
        //账号用户名验证
        return checkLogin(username,password,tel,null);
    }



    protected Result<SsoUser> checkLogin(String username,String password,String tel,List<String> sources){

        SsoUser ssoUser = new SsoUser();
        try {
            LambdaQueryWrapper<SysUser> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUser::getAccout, username);
            if(StrUtil.isNotBlank(tel)){
                queryWrapper.eq(SysUser::getTelEncrypt, AESUtils.encrypt(tel,AESUtils.KEY));
            }
            int iCount = sysUserMapper.selectCount(queryWrapper);
            if (iCount == 0){
                queryWrapper.clear();
                queryWrapper.and(gw->gw.eq(SysUser::getName, username)
                        .or()
                        .eq(SysUser::getAccout, username));
                if(StrUtil.isNotBlank(tel)){
                    queryWrapper.eq(SysUser::getTel,tel);
                }
            }

            if(sources!=null&&sources.size()!=0){
                queryWrapper.and(gw->gw.in(SysUser::getSource,sources));
            }
            queryWrapper.last(" limit 1");
            SysUser user = sysUserMapper.selectOne(queryWrapper);
            if (user == null || user.getId() == null) {
                return Result.createError("用户不存在或者密码错误");
            }
            if (!user.getStatus().toString().equals("1")) {
                return Result.createError("用户已停用或者状态异常，请联系管理员！");
            }
            SysUserSecurity sysUserSecurity = sysUserSecurityMapper.selectOne(new QueryWrapper<SysUserSecurity>()
                    .eq(TableFileds.SYS_USER_SECURITY_ID, user.getId())
                    .eq(TableFileds.SYS_USER_SECURITY_PASSWORD, passwordUtil.getMD5Password(password))
            );
            if (sysUserSecurity == null) {
                return Result.createError("用户不存在或者密码错误。");
            }
            if (sysUserSecurity.getLock() != null && sysUserSecurity.getLock() == 1) {
                return Result.createError("用户被锁定，请联系管理员!。");
            }
            List<SysRegion> regions = sysRegionMapper.queryUserRegions(user.getId());
            String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
            String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
            ssoUser.setId(user.getId());
            ssoUser.setUserid(user.getId());
            ssoUser.setUserName(user.getAname());
            ssoUser.setLoginName(user.getAccout());
            ssoUser.setRegionCode(regionCode);
            ssoUser.setRegionName(regionName);
            ssoUser.setCatalog(user.getCatalog());
            return Result.createSuccess(ssoUser);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }






}
