package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.design.biz.entity.BimOrg;
import com.geoway.design.biz.entity.BimUser;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.dev.IUserOrganizationService;
import com.geoway.design.biz.service.hunan.BimOrgService;
import com.geoway.design.biz.service.hunan.BimService;
import com.geoway.design.biz.service.hunan.BimUserService;
import com.geoway.design.biz.service.sys.ISysUserRegionService;
import com.geoway.design.biz.service.sys.ISysUserRoleService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.iam.Codec.IamFacade;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/**
 * @author AA
 */
@Service
@Transactional
@Slf4j
public class BimServiceImpl implements BimService {

    @Value("${hunan.BIM.remoteUser:}")
    private String bimRemoteUser;

    @Value("${hunan.BIM.remotePwd:}")
    private String bimRemotePwd;

    @Value("${hunan.BIM.secretKey:}")
    private String bimSecretKey;

    @Value("${hunan.BIM.roleId:}")
    private String bimRoleId;

    //加密秘钥
    private  final String type = "SM4";
    private  final String signType = "SM3";

    @Autowired
    BimUserService bimUserService;

    @Autowired
    BimOrgService bimOrgService;

    @Autowired
    ISysUserService userService;

    @Autowired
    IOrganizationService organizationService;

    @Autowired
    ISysUserRegionService sysUserRegionService;

    @Autowired
    ISysUserRoleService sysUserRoleService;

    @Autowired
    IUserOrganizationService userOrganizationService;


    @Override
    public String queryUserOrgSchema(JSONObject jsonInfo) {
        JSONObject resultJSON = new JSONObject();
        try {
            if (!validPermisson(jsonInfo, resultJSON)){
                return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
            }

            //用户表结构
            //"userId", "userName", "tel", "alisName", "xzqdm", "email", "orgId"
            List<String> mustFieldList = Arrays.asList(new String[]{"username","tel","alisname","xzqdm","email","sex","userid","usercode","orgid"});
            JSONArray accountJson = new JSONArray();
            for (String fieldName : mustFieldList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("multivalued", "false");
                jsonObject.put("name", fieldName);
                jsonObject.put("required", "true");
                jsonObject.put("type", "String");
                accountJson.add(jsonObject);
            }
            resultJSON.put("account", accountJson);

            //权限（组织机构表）结构
            //"orgId", "orgName", "level", "orgCode", "parentId"
            List<String> mustRoleFieldList = Arrays.asList(new String[]{"orgname","level","orgid","orgcode","parenetid"});
            JSONArray organizationJson = new JSONArray();
            for (String fieldName : mustRoleFieldList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("multivalued", "false");
                jsonObject.put("name", fieldName);
                jsonObject.put("required", "true");
                if ("level".equals(fieldName)) {
                    jsonObject.put("type", "int");
                } else {
                    jsonObject.put("type", "String");
                }
                organizationJson.add(jsonObject);
            }
            resultJSON.put("organization", organizationJson);
        }catch (Exception ex){
            log.error("获取用户和组织属性失败",ex);
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "获取用户和组织属性失败");
        }

        //返回信息加密
        return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
    }

    @Override
    public String saveUser(JSONObject jsonInfo) {

        JSONObject resultJSON = new JSONObject();
        try{
            //参数解密
            if (!validPermisson(jsonInfo, resultJSON)){
                return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
            }

            String userId = jsonInfo.getString("userid");
            String username = jsonInfo.getString("username");
            String tel = jsonInfo.getString("tel");
            String alisname = jsonInfo.getString("alisname");
            String email = jsonInfo.getString("email");
            String orgid = jsonInfo.getString("orgid");
            String xzqdm = jsonInfo.getString("xzqdm");
            Integer sex =  jsonInfo.getInteger("sex");

            //对比手机号查看是否拥有相同账号
            BimUser bimUser = new BimUser();

            bimUser.setTel(tel);
            bimUser.setId(userId);
            bimUser.setName(username);
            bimUser.setAname(alisname);
            bimUser.setEmail(email);
            if(sex != null){
                bimUser.setSex(sex);
            }
            bimUserService.saveBimUser(bimUser);

            //绑定角色
            if(StrUtil.isNotBlank(bimRoleId)){
                List<String> roleIds = new ArrayList<>();
                roleIds.add(bimRoleId);
                sysUserRoleService.updateUserRole(bimUser.getId(),roleIds);
            }

            //绑定所属行政区
            if(StrUtil.isNotBlank(xzqdm)){
                List<String> xzqdms = new ArrayList<>();
                xzqdms.add(xzqdm);
                sysUserRegionService.updateUserRegions(bimUser.getId(),xzqdms);
            }
            //绑定对应的组织结构
            if(StrUtil.isNotBlank(orgid)){
                List<String> orgIds = new ArrayList<>();
                orgIds.add(orgid);
                userOrganizationService.updateUserOrg(bimUser.getId(),orgIds);
            }

            resultJSON.put("resultCode", 0);
            resultJSON.put("uid", bimUser.getId());
            resultJSON.put("message", "success");

        }catch (Exception ex) {
            log.error("账号创建失败",ex);
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "账号创建失败");
        }

        return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
    }

    @Override
    public String deleteUser(JSONObject jsonInfo) {

        JSONObject resultJSON = new JSONObject();
        try {
            //参数解密
            if (!validPermisson(jsonInfo, resultJSON)){
                return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
            }
            String bimUid =(String) jsonInfo.get("bimUid");
            userService.deleteOne(bimUid);

            resultJSON.put("resultCode", 0);
            resultJSON.put("message", "success");
        }catch (Exception ex) {
            log.error("账号删除失败",ex);
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "账号删除失败");
        }

        return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
    }

    @Override
    public String saveOrg(JSONObject jsonInfo) {

        JSONObject resultJSON = new JSONObject();
        try {
            //参数解密
            if (!validPermisson(jsonInfo, resultJSON)){
                return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
            }

            String orgId = jsonInfo.getString("orgid");
            String orgName =  jsonInfo.getString("orgname");
            Integer ilevel = jsonInfo.getInteger("level");
            String orgCode =  jsonInfo.getString("orgcode");
            String parentId = jsonInfo.getString("parenetid");

            BimOrg bimOrg = new BimOrg();
            bimOrg.setId(orgId);
            bimOrg.setPid(parentId);
            bimOrg.setName(orgName);
            bimOrg.setAname(orgName);
            if( ilevel != null){
                bimOrg.setLevel(ilevel);
            }

            bimOrg.setCode(orgCode);
            bimOrgService.saveBimOrg(bimOrg);

            resultJSON.put("resultCode", 0);
            resultJSON.put("uid", bimOrg.getId());
            resultJSON.put("message", "success");

        } catch (Exception ex) {
            log.error("组织机构创建失败",ex);
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "组织机构创建失败");
        }
        //返回信息加密
        return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
    }

    @Override
    public String deleteOrg(JSONObject jsonInfo) {

        JSONObject resultJSON = new JSONObject();
        try {
            //参数解密
            //参数解密
            if (!validPermisson(jsonInfo, resultJSON)){
                return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
            }
            String bimOrgId =(String) jsonInfo.get("bimOrgId");
            organizationService.batchDelete(bimOrgId);

            resultJSON.put("resultCode", 0);
            resultJSON.put("message", "success");
        }catch (Exception ex) {
            log.error("组织机构创建失败",ex);
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "账号删除失败");
        }

        return IamFacade.encrypt(resultJSON.toJSONString(), bimSecretKey, type);
    }

    private boolean validPermisson(JSONObject jsonInfo, JSONObject resultJSON) {
        //参数解密
        resultJSON.put("bimRequestId", jsonInfo.get("bimRequestId"));
        //签名验证
//        if (!verify(jsonInfo)) {
//            resultJSON.put("resultCode", 500);
//            resultJSON.put("message", "校验不通过");
//            return false;
//        }
        //验证传入用户
        String usernameBiz = jsonInfo.get("bimRemoteUser").toString();
        String passwordBiz = jsonInfo.get("bimRemotePwd").toString();
        if (!(usernameBiz.equals(bimRemoteUser) && passwordBiz.equals(bimRemotePwd))) {
            resultJSON.put("resultCode", 500);
            resultJSON.put("message", "用户权限验证失败");
            return false;
        }
        return true;
    }


    //验证签名
    private Boolean verify(JSONObject reqmap) {

        StringBuffer sb = new StringBuffer();
        Iterator<String> ittree = reqmap.keySet().iterator();
        while (ittree.hasNext()) {
            String key = (String) ittree.next();
            if (!"signature".equals(key)) {
                sb.append(key).append("=").append(reqmap.get(key)).append("&");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        System.out.println(reqmap.get("signature") + "  now  " + sb.toString());
        return IamFacade.verify(reqmap.get("signature").toString(), sb.toString(), signType);
    }
}


