package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.design.biz.entity.BimUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.BimUserMapper;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.hunan.BimUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * @author AA
 */
@Service
@Transactional
public class BimUserServiceImpl extends ServiceImpl<BimUserMapper, BimUser>  implements BimUserService {

    @Value("${password.initPassword:e10adc3949ba59abbe56e057f20f883e}")
    private String initPassword;

    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;

    @Override
    public void saveBimUser(BimUser bimUser) throws Exception {

        BimUser oldUser = this.getById(bimUser.getId());
        //是否新增
        boolean isAdd =(oldUser == null);
        if (StrUtil.isBlank(bimUser.getName())) {
            throw new RuntimeException("用户名不能为空");
        }
        bimUser.setAccout(bimUser.getName());

        String tel = bimUser.getTel();
        if (StrUtil.isBlank(tel)) {
            throw new RuntimeException("手机号不能为空");
        }
        if (tel.length()!=11) {
            throw new RuntimeException("手机号格式错误");
        }

        // 手机号隐藏中间4位
        //bimUser.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));
        //bimUser.setTelEncrypt(AESUtils.encrypt(tel,AESUtils.KEY));

        //判断名称和账号是否重复
        LambdaQueryWrapper<BimUser> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BimUser::getName, bimUser.getName());
        wrapper.or();
        wrapper.eq(BimUser::getTel,bimUser.getTel());
        if(isAdd){
           bimUser.setCreatetime(new Date());
        }else{
            bimUser.setUpdatetime(new Date());
            wrapper.ne(BimUser::getId, bimUser.getId());
        }

        //新增: 检查账号是否重复，重复就更新下
        int iCount = this.count(wrapper);
        if (iCount > 0) {
            wrapper.last(" limit 1");
            oldUser = this.getOne(wrapper);
            bimUser.setId(oldUser.getId());
        }

        this.saveOrUpdate(bimUser);
        this.setPassword(bimUser.getId());

    }

    private void setPassword(String userId) {
        boolean isAdd = false;
        SysUserSecurity sysUserSecurity = sysUserSecurityMapper.selectById(userId);
        if (sysUserSecurity == null) {
            sysUserSecurity = new SysUserSecurity();
            sysUserSecurity.setId(userId);
            isAdd = true;
        }
        sysUserSecurity.setPassword(initPassword);
        if(isAdd){
            sysUserSecurityMapper.insert(sysUserSecurity);
        }else{
            sysUserSecurityMapper.updateById(sysUserSecurity);
        }
    }
}


