package com.geoway.design.biz.service.hunan.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.design.biz.entity.SysUser;
import com.geoway.design.biz.entity.SysUserSecurity;
import com.geoway.design.biz.mapper.SysUserSecurityMapper;
import com.geoway.design.biz.service.hunan.IDPService;
import com.geoway.design.biz.service.login.ISysLoginService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * @author AA
 */
@Service
@Transactional
public class IDPServiceImpl implements IDPService {

    @Value("${hunan.IDP.url:}")
    private String serverUrl;

    @Value("${hunan.IDP.clientId:}")
    private String clientId;

    @Value("${hunan.IDP.clientSecret:}")
    private String clientSecret;

    @Autowired
    private ProjectConfig projectConfig;

    @Autowired
    ISysUserService userService;

    @Autowired
    ISysLoginService sysLoginService;

    @Autowired
    SysUserSecurityMapper sysUserSecurityMapper;

    @Autowired
    private IOauth2Service ssoOauth2Service;


    @Override
    public String queryAccessToken(String code) throws Exception {
        Map<String, Object> formMap=new HashMap<>();
        formMap.put("grant_type","authorization_code");
        formMap.put("code",code);
        formMap.put("client_id",clientId);
        formMap.put("client_secret",clientSecret);
        String result = HttpRequest.post(serverUrl+"idp/oauth2/getToken").form(formMap).contentType("application/x-www-form-urlencoded").execute().body();
        JSONObject responseJSON = JSONObject.parseObject(result);
        if (responseJSON.containsKey("errcode")) {
            String msg = "获取统一身份认证平台授权码失败！"+responseJSON.getString("errcode")+":"+responseJSON.getString("msg");
            throw new Exception(msg);
        }
        String accessToken=responseJSON.getString("access_token");
        return  accessToken;
    }

    @Override
    public SysUser queryUserInfo(String accessToken) throws Exception {

        //获取用户信息
         String result = HttpRequest.get(serverUrl+"idp/oauth2/getUserInfo?access_token="+accessToken).execute().body();
         JSONObject  responseJSON = JSONObject.parseObject(result);
        if (responseJSON.containsKey("errcode")) {
            String msg = "获取统一身份认证平台登录令牌失败！"+responseJSON.getString("errcode")+":"+responseJSON.getString("msg");
            throw new Exception(msg);
        }

        String username=responseJSON.getString("userName");
        LambdaQueryWrapper<SysUser> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUser::getAccout, username);
        int iCount = userService.count(queryWrapper);
        if (iCount == 0){
            queryWrapper.clear();
            queryWrapper.and(gw->gw.eq(SysUser::getName, username)
                    .or()
                    .eq(SysUser::getAccout, username));
        }
        queryWrapper.last(" limit 1");
        SysUser user = userService.getOne(queryWrapper);

        return user;
    }

    @Override
    public ResponseDataBase loginByAuthCode(HttpServletRequest request, String code) throws Exception {

        String accessToken = this.queryAccessToken(code);
        SysUser user = this.queryUserInfo(accessToken);
        if(user == null){
            return ResponseDataBase.error("未查询到对应用户信息");
        }

        ResponseDataBase response = new ResponseDataBase();
        SysUserSecurity sysUserSecurity = sysUserSecurityMapper.selectById(user.getId());
        String password = sysUserSecurity == null ? "": sysUserSecurity.getPassword();
        RpcAccessToken rpcAccessToken=ssoOauth2Service.getAccessToken(projectConfig.getSsoAppId(),projectConfig.getSsoAppSecret(),user.getName(), password,accessToken);
        SessionUtils.setAccessToken(request, rpcAccessToken);
        SsoUser ssoUser = rpcAccessToken.getUser();
        response.put("token", rpcAccessToken.getAccessToken());
        response.put("expiresIn",rpcAccessToken.getExpiresIn());
        response.put("refreshToken",rpcAccessToken.getRefreshToken());
        response.put("userId", user.getId());
        response.put("username", ssoUser.getLoginName());
        response.put("alisname", ssoUser.getUserName());
        response.put("status", "OK");
        response.put("validateType", "sso");
        response.put("passwordPolicy",ssoUser.getPasswordPolicy());

        response.put("regionCode", ssoUser.getRegionCode());
        response.put("regionName", ssoUser.getRegionName());

        return response;
    }

    @Override
    public void logoutByAccessToken(String accessToken) throws Exception {
        String str = HttpRequest.get(serverUrl + "idp/oauth2/revokeToken?access_token=" + accessToken).execute().body();
        JSONObject responseJSON = JSONObject.parseObject(str);
        if (responseJSON.containsKey("errcode")) {
            String msg = "退出登录失败！"+responseJSON.getString("errcode")+":"+responseJSON.getString("msg");
            throw new Exception(msg);
        }
    }
}


