package com.geoway.design.biz.service.login.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.support.RedisUtil;
import com.geoway.design.biz.service.login.ICaptchaService;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.constant.AppConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@Service("commonService")
public class CaptchaServiceImpl implements ICaptchaService {
    @Value("${app.setting.captcha.length:4}")
    private int codeCount;

    @Value("${app.setting.captcha.width:96}")
    private int width;

    @Value("${app.setting.captcha.height:32}")
    private int height;

    char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    PropertyConfig propertyConfig;


    @Override
    public BufferedImage createImageCaptcha(String imageWidth, String imageHeight, HttpServletRequest req, HttpServletResponse resp) {
        if (StringUtils.isNotBlank(imageWidth)) {
            this.width = Integer.parseInt(imageWidth);
        }
        if (StringUtils.isNotBlank(imageHeight)) {
            this.height = Integer.parseInt(imageHeight);
        }
        int xx = this.width / (this.codeCount + 1);
        BufferedImage buffImg = new BufferedImage(this.width, this.height, 1);
        Graphics2D gd = buffImg.createGraphics();
        Random random = new Random();
        gd.setColor(Color.WHITE);
        gd.fillRect(0, 0, this.width, this.height);
        Font font = new Font("Fixedsys", 0, this.height - 2);
        gd.setFont(font);
        gd.setColor(Color.BLACK);
        for (int i = 0; i < 2; i++) {
            int x = random.nextInt(this.width);
            int y = random.nextInt(this.height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            gd.drawLine(x, y, x + xl, y + yl);
        }
        StringBuffer randomCode = new StringBuffer();
        int red = 0, green = 0, blue = 0;
        for (int j = 0; j < this.codeCount; j++) {
            String strRand = String.valueOf(this.codeSequence[random.nextInt(36)]);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawString(strRand, (j + 1) * xx, height - 4);
            randomCode.append(strRand);
        }
        req.getSession().setAttribute(AppConstant.Verify_Code, randomCode.toString());
        return buffImg;
    }

    @Override
    public void storeCaptcha(String sessionId, String captchaText) {
        String key = sessionId + AppConstant.CAPTCHA_SESSION_TEXT;
        redisUtil.set(key, captchaText, 3, TimeUnit.MINUTES);
    }

    @Override
    public String queryCaptcha(String sessionId) {
        String key = sessionId + AppConstant.CAPTCHA_SESSION_TEXT;
        return (String) redisUtil.get(key);
    }

    @Override
    public boolean validateCaptcha(String code, String storeCode) {
        Boolean isDev = propertyConfig.getRunMode().indexOf("dev") > -1;
        if (StrUtil.isBlank(storeCode) || StrUtil.isBlank(code)) {
            return false;
        }
        if (isDev) {
            if (!code.equalsIgnoreCase(storeCode) && !code.equalsIgnoreCase("4567")) {
                return false;
            }
        } else {
            if (!code.equalsIgnoreCase(storeCode)) {
                return false;
            }
        }
        return true;
    }
}
